/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.system;

import com.antgroup.geaflow.cluster.system.IClusterMetaKVStore;
import com.antgroup.geaflow.cluster.system.MemoryClusterMetaKVStore;
import com.antgroup.geaflow.cluster.system.RocksdbClusterMetaKVStore;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.FrameworkConfigKeys;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.state.serializer.DefaultKVSerializer;
import com.antgroup.geaflow.state.serializer.IKeySerializer;
import com.antgroup.geaflow.store.context.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMetaStoreFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterMetaStoreFactory.class);
    private static final int DEFAULT_SHARD_ID = 0;

    public static <K, V> IClusterMetaKVStore<K, V> create(String name, Configuration configuration) {
        return ClusterMetaStoreFactory.create(name, 0, configuration);
    }

    public static <K, V> IClusterMetaKVStore<K, V> create(String name, int shardId, Configuration configuration) {
        StoreContext storeContext = new StoreContext(name);
        storeContext.withKeySerializer((IKeySerializer)new DefaultKVSerializer(null, null));
        storeContext.withConfig(configuration);
        storeContext.withShardId(shardId);
        String backendType = configuration.getString(FrameworkConfigKeys.SYSTEM_STATE_BACKEND_TYPE);
        IClusterMetaKVStore<K, V> store = ClusterMetaStoreFactory.create(StoreType.getEnum((String)backendType));
        store.init(storeContext);
        return store;
    }

    private static <K, V> IClusterMetaKVStore<K, V> create(StoreType storeType) {
        IClusterMetaKVStore clusterMetaKVStore;
        switch (storeType) {
            case ROCKSDB: {
                LOGGER.info("create rocksdb cluster metastore");
                clusterMetaKVStore = new RocksdbClusterMetaKVStore();
                break;
            }
            default: {
                LOGGER.info("create memory cluster metastore");
                clusterMetaKVStore = new MemoryClusterMetaKVStore();
            }
        }
        return clusterMetaKVStore;
    }
}

