/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.system;

import com.antgroup.geaflow.cluster.system.IClusterMetaKVStore;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.api.key.StoreBuilderFactory;
import com.antgroup.geaflow.store.context.StoreContext;

public class MemoryClusterMetaKVStore<V>
implements IClusterMetaKVStore<String, V> {
    private IKVStore<String, Object> kvStore;

    @Override
    public void init(StoreContext storeContext) {
        IStoreBuilder builder = StoreBuilderFactory.build((String)StoreType.MEMORY.name());
        this.kvStore = (IKVStore)builder.getStore(DataModel.KV, storeContext.getConfig());
    }

    @Override
    public void flush() {
    }

    public V get(String key) {
        return (V)this.kvStore.get((Object)key);
    }

    public void put(String key, V value) {
        this.kvStore.put((Object)key, value);
    }

    public void remove(String key) {
        this.kvStore.remove((Object)key);
    }

    @Override
    public void close() {
        this.kvStore.close();
    }
}

