/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.system;

import com.antgroup.geaflow.cluster.system.IClusterMetaKVStore;
import com.antgroup.geaflow.state.DataModel;
import com.antgroup.geaflow.state.StoreType;
import com.antgroup.geaflow.store.IStoreBuilder;
import com.antgroup.geaflow.store.api.key.IKVStore;
import com.antgroup.geaflow.store.api.key.StoreBuilderFactory;
import com.antgroup.geaflow.store.context.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksdbClusterMetaKVStore<K, V>
implements IClusterMetaKVStore<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocksdbClusterMetaKVStore.class);
    private static final Integer DEFAULT_VERSION = 1;
    private IKVStore<K, Object> kvStore;
    private transient long version;

    @Override
    public void init(StoreContext storeContext) {
        IStoreBuilder builder = StoreBuilderFactory.build((String)StoreType.ROCKSDB.name());
        this.kvStore = (IKVStore)builder.getStore(DataModel.KV, storeContext.getConfig());
        this.kvStore.init(storeContext);
        long latest = this.kvStore.recoveryLatest();
        if (latest > 0L) {
            LOGGER.info("recovery to latest version {}", (Object)latest);
            this.version = latest + 1L;
        } else {
            LOGGER.info("not found any version to recovery");
            this.version = DEFAULT_VERSION.intValue();
        }
    }

    @Override
    public void flush() {
        this.kvStore.archive(this.version);
        ++this.version;
    }

    public V get(K key) {
        return (V)this.kvStore.get(key);
    }

    public void put(K key, V value) {
        this.kvStore.put(key, value);
    }

    public void remove(K key) {
        this.kvStore.remove(key);
    }

    @Override
    public void close() {
        this.kvStore.close();
    }
}

