/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.task;

import com.antgroup.geaflow.cluster.collector.EmitterService;
import com.antgroup.geaflow.cluster.fetcher.FetcherService;
import com.antgroup.geaflow.cluster.task.ITaskContext;
import com.antgroup.geaflow.cluster.task.runner.ITaskRunnerContext;
import com.antgroup.geaflow.cluster.worker.IWorker;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.metrics.common.api.MetricGroup;

public class TaskContext
implements ITaskContext {
    private int workerIndex;
    private Configuration config;
    private MetricGroup metricGroup;
    private IWorker worker;
    private FetcherService fetcherService;
    private EmitterService emitterService;

    public TaskContext(ITaskRunnerContext taskContext) {
        this.workerIndex = taskContext.getWorkerIndex();
        this.config = taskContext.getConfig();
        this.metricGroup = taskContext.getMetricGroup();
        this.fetcherService = taskContext.getFetcherService();
        this.emitterService = taskContext.getEmitterService();
    }

    @Override
    public IWorker getWorker() {
        return this.worker;
    }

    @Override
    public void registerWorker(IWorker worker) {
        this.worker = worker;
    }

    @Override
    public FetcherService getFetcherService() {
        return this.fetcherService;
    }

    @Override
    public EmitterService getEmitterService() {
        return this.emitterService;
    }

    @Override
    public int getWorkerIndex() {
        return this.workerIndex;
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public MetricGroup getMetricGroup() {
        return this.metricGroup;
    }

    @Override
    public void close() {
        this.worker.close();
        this.fetcherService.shutdown();
        this.emitterService.shutdown();
    }
}

