/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.task.runner;

import com.antgroup.geaflow.cluster.protocol.ICommand;
import com.antgroup.geaflow.cluster.protocol.IExecutableCommand;
import com.antgroup.geaflow.cluster.task.Task;
import com.antgroup.geaflow.cluster.task.TaskContext;
import com.antgroup.geaflow.cluster.task.runner.AbstractTaskRunner;
import com.antgroup.geaflow.cluster.task.runner.ITaskRunnerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner
extends AbstractTaskRunner<ICommand> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRunner.class);
    private Task task;
    private ITaskRunnerContext taskRunnerContext;

    public void init(ITaskRunnerContext taskRunnerContext) {
        this.taskRunnerContext = taskRunnerContext;
    }

    @Override
    protected void process(ICommand command) {
        LOGGER.info("task Executor:{}", (Object)command);
        switch (command.getEventType()) {
            case CREATE_TASK: {
                this.task = new Task();
                this.task.init(new TaskContext(this.taskRunnerContext));
                break;
            }
            case DESTROY_TASK: {
                this.task.close();
                this.task = null;
                break;
            }
            default: {
                this.task.execute((IExecutableCommand)command);
            }
        }
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.task != null) {
            this.task.interrupt();
        }
    }
}

