/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.task.service;

import com.antgroup.geaflow.cluster.exception.ComponentUncaughtExceptionHandler;
import com.antgroup.geaflow.cluster.task.runner.ITaskRunner;
import com.antgroup.geaflow.cluster.task.service.ITaskService;
import com.antgroup.geaflow.common.thread.Executors;
import com.antgroup.geaflow.common.utils.ExecutorUtil;
import com.google.common.base.Preconditions;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTaskService<TASK, R extends ITaskRunner<TASK>>
implements ITaskService<TASK> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTaskService.class);
    protected ExecutorService executorService;
    private R[] tasks;
    private String threadFormat;

    public AbstractTaskService(String threadFormat) {
        this.threadFormat = threadFormat;
    }

    @Override
    public void start() {
        this.tasks = this.buildTaskRunner();
        Preconditions.checkArgument((this.tasks != null && this.tasks.length != 0 ? 1 : 0) != 0, (Object)"must specify at least one task");
        this.executorService = Executors.getExecutorService((int)this.tasks.length, (String)this.threadFormat, (Thread.UncaughtExceptionHandler)new ComponentUncaughtExceptionHandler());
        for (int i = 0; i < this.tasks.length; ++i) {
            this.executorService.execute((Runnable)this.tasks[i]);
        }
    }

    @Override
    public void process(int workerId, TASK task) {
        this.tasks[workerId].add(task);
    }

    @Override
    public void interrupt(int workerId) {
        this.tasks[workerId].interrupt();
    }

    @Override
    public void shutdown() {
        LOGGER.info("shutdown executor service {}", (Object)this.threadFormat);
        for (int i = 0; i < this.tasks.length; ++i) {
            this.tasks[i].shutdown();
        }
        ExecutorUtil.shutdown((ExecutorService)this.executorService);
    }

    public R getRunner(int workerId) {
        return this.tasks[workerId];
    }

    protected abstract R[] buildTaskRunner();
}

