/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.web;

import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatManager;
import com.antgroup.geaflow.cluster.web.handler.ClusterHttpHandler;
import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpServer.class);
    private static final String SERVER_NAME = "jetty-server";
    private static final int DEFAULT_ACCEPT_QUEUE_SIZE = 8;
    private final ClusterHttpHandler clusterHandler;
    private final Server server;
    private final int httpPort;
    private final QueuedThreadPool threadPool;
    private final ScheduledExecutorScheduler serverExecutor;

    public HttpServer(Configuration configuration, IClusterManager clusterManager, HeartbeatManager heartbeatManager) {
        this.clusterHandler = new ClusterHttpHandler(clusterManager, heartbeatManager);
        this.httpPort = configuration.getInteger(ExecutionConfigKeys.MASTER_HTTP_PORT);
        this.threadPool = new QueuedThreadPool();
        this.threadPool.setDaemon(true);
        this.threadPool.setName(SERVER_NAME);
        this.server = new Server((ThreadPool)this.threadPool);
        ErrorHandler errorHandler = new ErrorHandler();
        errorHandler.setShowStacks(true);
        errorHandler.setServer(this.server);
        this.server.addBean((Object)errorHandler);
        this.serverExecutor = new ScheduledExecutorScheduler("jetty-scheduler", true);
    }

    public void start() {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.addServlet(new ServletHolder((Servlet)this.clusterHandler), "/rest/cluster");
        contexts.addHandler((Handler)contextHandler);
        try {
            ServerConnector connector = this.newConnector(this.server, this.serverExecutor, null, this.httpPort);
            connector.setName(SERVER_NAME);
            this.server.addConnector((Connector)connector);
            int minThreads = 1;
            this.threadPool.setMaxThreads(Math.max(this.threadPool.getMaxThreads(), minThreads += connector.getAcceptors() * 2));
            this.server.start();
            LOGGER.info("Jetty Server started: {}", (Object)this.httpPort);
        }
        catch (Exception e) {
            LOGGER.error("jetty server failed:", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
            if (this.threadPool.isStarted()) {
                this.threadPool.stop();
            }
            if (this.serverExecutor.isStarted()) {
                this.serverExecutor.stop();
            }
        }
        catch (Exception e) {
            LOGGER.warn("stop jetty server failed", (Throwable)e);
            throw new GeaflowRuntimeException((Throwable)e);
        }
    }

    private ServerConnector newConnector(Server server, ScheduledExecutorScheduler serverExecutor, String hostName, int port) throws Exception {
        ConnectionFactory[] connectionFactories = new ConnectionFactory[]{new HttpConnectionFactory()};
        ServerConnector connector = new ServerConnector(server, null, (Scheduler)serverExecutor, null, -1, -1, connectionFactories);
        connector.setHost(hostName);
        connector.setPort(port);
        connector.start();
        connector.setAcceptQueueSize(Math.min(connector.getAcceptors(), 8));
        return connector;
    }
}

