/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.cluster.web.handler;

import com.alibaba.fastjson.JSONObject;
import com.antgroup.geaflow.cluster.clustermanager.AbstractClusterManager;
import com.antgroup.geaflow.cluster.clustermanager.IClusterManager;
import com.antgroup.geaflow.cluster.container.ContainerInfo;
import com.antgroup.geaflow.cluster.heartbeat.HeartbeatManager;
import com.antgroup.geaflow.cluster.web.handler.AbstractHttpHandler;
import com.antgroup.geaflow.common.heartbeat.Heartbeat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClusterHttpHandler
extends AbstractHttpHandler {
    private static final String TOTAL_CONTAINER_NUM = "totalNum";
    private static final String ACTIVE_CONTAINER_NUM = "activeNum";
    private static final String CONTAINER_LIST_KEY = "containers";
    private static final String CONTAINER_ID_KEY = "id";
    private static final String CONTAINER_NAME_KEY = "name";
    private static final String CONTAINER_HOST_KEY = "host";
    private static final String PROCESS_ID_KEY = "pid";
    private static final String PROCESS_METRICS_KEY = "metrics";
    private static final String LAST_UPDATE_TIME = "lastTimestamp";
    private final AbstractClusterManager clusterManager;
    private final HeartbeatManager heartbeatManager;

    public ClusterHttpHandler(IClusterManager clusterManager, HeartbeatManager heartbeatManager) {
        this.clusterManager = (AbstractClusterManager)clusterManager;
        this.heartbeatManager = heartbeatManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        JSONObject ret = new JSONObject();
        try {
            Map<Integer, Heartbeat> heartbeatMap = this.heartbeatManager.getHeartBeatMap();
            Map<Integer, ContainerInfo> containerMap = this.clusterManager.getContainerInfos();
            Set<Integer> containerIndex = this.clusterManager.getContainerIds();
            int totalContainerNum = containerIndex.size();
            ArrayList<JSONObject> containerList = new ArrayList<JSONObject>();
            int activeContainers = 0;
            for (Map.Entry<Integer, ContainerInfo> entry : containerMap.entrySet()) {
                JSONObject containerObj = new JSONObject();
                containerObj.put(CONTAINER_ID_KEY, (Object)entry.getKey());
                ContainerInfo info = entry.getValue();
                containerObj.put(CONTAINER_NAME_KEY, (Object)info.getName());
                containerObj.put(CONTAINER_HOST_KEY, (Object)info.getHost());
                containerObj.put(PROCESS_ID_KEY, (Object)info.getPid());
                Heartbeat heartbeat = heartbeatMap.get(entry.getKey());
                if (heartbeat != null) {
                    containerObj.put(LAST_UPDATE_TIME, (Object)heartbeat.getTimestamp());
                    containerObj.put(PROCESS_METRICS_KEY, (Object)heartbeat.getProcessMetrics());
                    ++activeContainers;
                }
                containerList.add(containerObj);
            }
            ret.put(TOTAL_CONTAINER_NUM, (Object)totalContainerNum);
            ret.put(ACTIVE_CONTAINER_NUM, (Object)activeContainers);
            ret.put(CONTAINER_LIST_KEY, containerList);
            resp.setStatus(200);
        }
        catch (Exception ex) {
            ret.put("error", (Object)ex.getMessage());
            resp.setStatus(500);
        }
        finally {
            this.addHeader(resp);
            resp.getWriter().write(ret.toJSONString());
            resp.getWriter().flush();
        }
    }
}

