/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.collection.array;

import com.antgroup.geaflow.collection.array.BooleanArray;
import com.antgroup.geaflow.collection.array.ByteArray;
import com.antgroup.geaflow.collection.array.BytesArray;
import com.antgroup.geaflow.collection.array.DoubleArray;
import com.antgroup.geaflow.collection.array.FloatArray;
import com.antgroup.geaflow.collection.array.IntArray;
import com.antgroup.geaflow.collection.array.LongArray;
import com.antgroup.geaflow.collection.array.ObjectArray;
import com.antgroup.geaflow.collection.array.PrimitiveArray;
import com.antgroup.geaflow.collection.array.ShortArray;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class PrimitiveArrayFactory {
    private static final Function<Integer, PrimitiveArray> DEFAULT_BUILDER = ObjectArray::new;
    private static final Map<Class<?>, Function<Integer, PrimitiveArray>> UNMARSHALL = new HashMap();

    public static PrimitiveArray getCustomArray(Class<?> type, int capacity) {
        return UNMARSHALL.getOrDefault(type, DEFAULT_BUILDER).apply(capacity);
    }

    static {
        UNMARSHALL.put(Integer.class, IntArray::new);
        UNMARSHALL.put(Integer.TYPE, IntArray::new);
        UNMARSHALL.put(Long.class, LongArray::new);
        UNMARSHALL.put(Long.TYPE, LongArray::new);
        UNMARSHALL.put(Double.class, DoubleArray::new);
        UNMARSHALL.put(Double.TYPE, DoubleArray::new);
        UNMARSHALL.put(Byte.class, ByteArray::new);
        UNMARSHALL.put(Byte.TYPE, ByteArray::new);
        UNMARSHALL.put(Float.class, FloatArray::new);
        UNMARSHALL.put(Float.TYPE, FloatArray::new);
        UNMARSHALL.put(Boolean.class, BooleanArray::new);
        UNMARSHALL.put(Boolean.TYPE, BooleanArray::new);
        UNMARSHALL.put(Short.class, ShortArray::new);
        UNMARSHALL.put(Short.TYPE, ShortArray::new);
        UNMARSHALL.put(byte[].class, BytesArray::new);
    }
}

