/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.collection.map;

import com.antgroup.geaflow.collection.PrimitiveType;
import it.unimi.dsi.fastutil.bytes.Byte2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ByteOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2FloatOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2IntOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2LongOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.bytes.Byte2ShortOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2ByteArrayMap;
import it.unimi.dsi.fastutil.doubles.Double2ByteOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2FloatOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2IntOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2LongOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.doubles.Double2ShortOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2ByteArrayMap;
import it.unimi.dsi.fastutil.floats.Float2ByteOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2LongOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2ShortOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ByteArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2FloatOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ShortOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2FloatOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ShortOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ByteOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2FloatOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2IntOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2LongOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ShortOpenHashMap;
import java.util.HashMap;
import java.util.Map;

public class MapFactory {
    private static final Map<Class, MapFactoryAdaptor> ADAPTOR_MAP = new HashMap<Class, MapFactoryAdaptor>();
    private static final MapFactoryAdaptor DEFAULT_ADAPTOR = new ObjectMapFactoryAdaptor();

    public static <K, V> Map buildMap(Class<K> key, Class<V> value) {
        MapFactoryAdaptor adaptor = ADAPTOR_MAP.get(key);
        if (adaptor != null) {
            return adaptor.buildMap(value);
        }
        return DEFAULT_ADAPTOR.buildMap(value);
    }

    static {
        ADAPTOR_MAP.put(Integer.class, new IntMapFactoryAdaptor());
        ADAPTOR_MAP.put(Integer.TYPE, new IntMapFactoryAdaptor());
        ADAPTOR_MAP.put(Byte.class, new ByteMapFactoryAdaptor());
        ADAPTOR_MAP.put(Byte.TYPE, new ByteMapFactoryAdaptor());
        ADAPTOR_MAP.put(Double.class, new DoubleMapFactoryAdaptor());
        ADAPTOR_MAP.put(Double.TYPE, new DoubleMapFactoryAdaptor());
        ADAPTOR_MAP.put(Long.class, new LongMapFactoryAdaptor());
        ADAPTOR_MAP.put(Long.TYPE, new LongMapFactoryAdaptor());
        ADAPTOR_MAP.put(Float.class, new FloatMapFactoryAdaptor());
        ADAPTOR_MAP.put(Float.TYPE, new FloatMapFactoryAdaptor());
        ADAPTOR_MAP.put(Short.class, new ShortMapFactoryAdaptor());
        ADAPTOR_MAP.put(Short.TYPE, new ShortMapFactoryAdaptor());
    }

    public static class ObjectMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Object2IntOpenHashMap();
                }
                case LONG: {
                    return new Object2LongOpenHashMap();
                }
                case BYTE: {
                    return new Object2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Object2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Object2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Object2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Object2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Object2ByteArrayMap();
                }
            }
            return new Object2ObjectOpenHashMap();
        }
    }

    public static class ShortMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Short2IntOpenHashMap();
                }
                case LONG: {
                    return new Short2LongOpenHashMap();
                }
                case BYTE: {
                    return new Short2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Short2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Short2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Short2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Short2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Short2ByteArrayMap();
                }
            }
            return new Short2ObjectOpenHashMap();
        }
    }

    public static class LongMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Long2IntOpenHashMap();
                }
                case LONG: {
                    return new Long2LongOpenHashMap();
                }
                case BYTE: {
                    return new Long2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Long2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Long2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Long2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Long2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Long2ByteArrayMap();
                }
            }
            return new Long2ObjectOpenHashMap();
        }
    }

    public static class IntMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Int2IntOpenHashMap();
                }
                case LONG: {
                    return new Int2LongOpenHashMap();
                }
                case BYTE: {
                    return new Int2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Int2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Int2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Int2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Int2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Int2ByteArrayMap();
                }
            }
            return new Int2ObjectOpenHashMap();
        }
    }

    public static class FloatMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Float2IntOpenHashMap();
                }
                case LONG: {
                    return new Float2LongOpenHashMap();
                }
                case BYTE: {
                    return new Float2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Float2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Float2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Float2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Float2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Float2ByteArrayMap();
                }
            }
            return new Float2ObjectOpenHashMap();
        }
    }

    public static class DoubleMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Double2IntOpenHashMap();
                }
                case LONG: {
                    return new Double2LongOpenHashMap();
                }
                case BYTE: {
                    return new Double2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Double2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Double2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Double2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Double2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Double2ByteArrayMap();
                }
            }
            return new Double2ObjectOpenHashMap();
        }
    }

    public static class ByteMapFactoryAdaptor
    implements MapFactoryAdaptor {
        @Override
        public <K, V> Map<K, V> buildMap(Class<V> value) {
            switch (PrimitiveType.getEnum(value.getSimpleName())) {
                case INT: {
                    return new Byte2IntOpenHashMap();
                }
                case LONG: {
                    return new Byte2LongOpenHashMap();
                }
                case BYTE: {
                    return new Byte2ByteOpenHashMap();
                }
                case FLOAT: {
                    return new Byte2FloatOpenHashMap();
                }
                case BOOLEAN: {
                    return new Byte2BooleanOpenHashMap();
                }
                case SHORT: {
                    return new Byte2ShortOpenHashMap();
                }
                case DOUBLE: {
                    return new Byte2DoubleOpenHashMap();
                }
                case BYTE_ARRAY: {
                    return new Byte2ByteArrayMap();
                }
            }
            return new Byte2ObjectOpenHashMap();
        }
    }

    public static interface MapFactoryAdaptor {
        public <K, V> Map<K, V> buildMap(Class<V> var1);
    }
}

