/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.binary;

import com.antgroup.geaflow.common.binary.HeapBinaryObject;
import com.antgroup.geaflow.common.binary.IBinaryObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class BinaryOperations {
    private static final Unsafe UNSAFE;
    public static final int BOOLEAN_ARRAY_OFFSET;
    public static final int BYTE_ARRAY_OFFSET;
    public static final int SHORT_ARRAY_OFFSET;
    public static final int INT_ARRAY_OFFSET;
    public static final int LONG_ARRAY_OFFSET;
    public static final int FLOAT_ARRAY_OFFSET;
    public static final int DOUBLE_ARRAY_OFFSET;
    private static final int MAJOR_VERSION;
    private static final boolean UNALIGNED;
    private static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    public static int getInt(IBinaryObject object, long offset) {
        return UNSAFE.getInt(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putInt(IBinaryObject object, long offset, int value) {
        UNSAFE.putInt(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static boolean getBoolean(IBinaryObject object, long offset) {
        return UNSAFE.getBoolean(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putBoolean(IBinaryObject object, long offset, boolean value) {
        UNSAFE.putBoolean(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static byte getByte(IBinaryObject object, long offset) {
        return UNSAFE.getByte(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putByte(IBinaryObject object, long offset, byte value) {
        UNSAFE.putByte(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static short getShort(IBinaryObject object, long offset) {
        return UNSAFE.getShort(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putShort(IBinaryObject object, long offset, short value) {
        UNSAFE.putShort(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static long getLong(IBinaryObject object, long offset) {
        return UNSAFE.getLong(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putLong(IBinaryObject object, long offset, long value) {
        UNSAFE.putLong(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static float getFloat(IBinaryObject object, long offset) {
        return UNSAFE.getFloat(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putFloat(IBinaryObject object, long offset, float value) {
        UNSAFE.putFloat(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static double getDouble(IBinaryObject object, long offset) {
        return UNSAFE.getDouble(object.getBaseObject(), object.getAbsoluteAddress(offset));
    }

    public static void putDouble(IBinaryObject object, long offset, double value) {
        UNSAFE.putDouble(object.getBaseObject(), object.getAbsoluteAddress(offset), value);
    }

    public static void copyMemory(byte[] src, long srcOffset, byte[] dst, long dstOffset, long length) {
        HeapBinaryObject srcObject = HeapBinaryObject.of(src);
        HeapBinaryObject dstObject = HeapBinaryObject.of(dst);
        BinaryOperations.copyMemory((IBinaryObject)srcObject, srcOffset, (IBinaryObject)dstObject, dstOffset, length);
    }

    public static void copyMemory(byte[] src, long srcOffset, IBinaryObject dst, long dstOffset, long length) {
        HeapBinaryObject srcObject = HeapBinaryObject.of(src);
        BinaryOperations.copyMemory((IBinaryObject)srcObject, srcOffset, dst, dstOffset, length);
    }

    public static void copyMemory(IBinaryObject src, long srcOffset, byte[] dst, long dstOffset, long length) {
        HeapBinaryObject dstObject = HeapBinaryObject.of(dst);
        BinaryOperations.copyMemory(src, srcOffset, (IBinaryObject)dstObject, dstOffset, length);
    }

    public static void copyMemory(IBinaryObject src, long srcOffset, IBinaryObject dst, long dstOffset, long length) {
        if (src.size() == 0 || length == 0L) {
            return;
        }
        if (dst.getAbsoluteAddress(dstOffset) < src.getAbsoluteAddress(srcOffset)) {
            while (length > 0L) {
                long size = Math.min(length, 0x100000L);
                UNSAFE.copyMemory(src.getBaseObject(), src.getAbsoluteAddress(srcOffset), dst.getBaseObject(), dst.getAbsoluteAddress(dstOffset), size);
                length -= size;
                srcOffset += size;
                dstOffset += size;
            }
        } else {
            srcOffset += length;
            dstOffset += length;
            while (length > 0L) {
                long size = Math.min(length, 0x100000L);
                UNSAFE.copyMemory(src.getBaseObject(), src.getAbsoluteAddress(srcOffset -= size), dst.getBaseObject(), dst.getAbsoluteAddress(dstOffset -= size), size);
                length -= size;
            }
        }
    }

    public static boolean arrayEquals(IBinaryObject leftBase, long leftOffset, IBinaryObject rightBase, long rightOffset, long length) {
        int i = 0;
        if (leftOffset % 8L == rightOffset % 8L) {
            while ((leftOffset + (long)i) % 8L != 0L && (long)i < length) {
                if (BinaryOperations.getByte(leftBase, leftOffset + (long)i) != BinaryOperations.getByte(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                ++i;
            }
        }
        if (UNALIGNED || (leftOffset + (long)i) % 8L == 0L && (rightOffset + (long)i) % 8L == 0L) {
            while ((long)i <= length - 8L) {
                if (BinaryOperations.getLong(leftBase, leftOffset + (long)i) != BinaryOperations.getLong(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                i += 8;
            }
        }
        while ((long)i < length) {
            if (BinaryOperations.getByte(leftBase, leftOffset + (long)i) != BinaryOperations.getByte(rightBase, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        boolean _unaligned;
        Unsafe unsafe;
        MAJOR_VERSION = Integer.parseInt(System.getProperty("java.version").split("\\D+")[0]);
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            unsafe = (Unsafe)unsafeField.get(null);
        }
        catch (Throwable cause) {
            unsafe = null;
        }
        UNSAFE = unsafe;
        if (UNSAFE != null) {
            BOOLEAN_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(boolean[].class);
            BYTE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(byte[].class);
            SHORT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(short[].class);
            INT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(int[].class);
            LONG_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(long[].class);
            FLOAT_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(float[].class);
            DOUBLE_ARRAY_OFFSET = UNSAFE.arrayBaseOffset(double[].class);
        } else {
            BOOLEAN_ARRAY_OFFSET = 0;
            BYTE_ARRAY_OFFSET = 0;
            SHORT_ARRAY_OFFSET = 0;
            INT_ARRAY_OFFSET = 0;
            LONG_ARRAY_OFFSET = 0;
            FLOAT_ARRAY_OFFSET = 0;
            DOUBLE_ARRAY_OFFSET = 0;
        }
        String arch = System.getProperty("os.arch", "");
        if (arch.equals("ppc64le") || arch.equals("ppc64") || arch.equals("s390x")) {
            _unaligned = true;
        } else {
            try {
                Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
                if (UNSAFE != null && MAJOR_VERSION >= 9) {
                    Field unalignedField = bitsClass.getDeclaredField(MAJOR_VERSION >= 11 ? "UNALIGNED" : "unaligned");
                    _unaligned = UNSAFE.getBoolean(UNSAFE.staticFieldBase(unalignedField), UNSAFE.staticFieldOffset(unalignedField));
                } else {
                    Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
                    unalignedMethod.setAccessible(true);
                    _unaligned = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
                }
            }
            catch (Throwable t) {
                _unaligned = arch.matches("^(i[3-6]86|x86(_64)?|x64|amd64|aarch64)$");
            }
        }
        UNALIGNED = _unaligned;
    }
}

