/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.binary;

import com.antgroup.geaflow.common.binary.BinaryOperations;
import com.antgroup.geaflow.common.binary.HeapBinaryObject;
import com.antgroup.geaflow.common.binary.IBinaryObject;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class BinaryString
implements Comparable<BinaryString>,
Serializable,
KryoSerializable {
    private static final boolean IS_LITTLE_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN;
    private IBinaryObject binaryObject;
    private long offset;
    private int numBytes;
    private transient int hashCode = 0;
    private static byte[] bytesOfCodePointInUTF8 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final BinaryString EMPTY_STRING = BinaryString.fromString("");

    public BinaryString() {
    }

    public BinaryString(IBinaryObject binaryObject, long offset, int numBytes) {
        this.binaryObject = binaryObject;
        this.offset = offset;
        this.numBytes = numBytes;
    }

    public static BinaryString fromString(String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return new BinaryString(HeapBinaryObject.of(bytes), 0L, bytes.length);
    }

    public static BinaryString fromBytes(byte[] bytes) {
        return new BinaryString(HeapBinaryObject.of(bytes), 0L, bytes.length);
    }

    public byte[] getBytes() {
        if (this.offset == 0L && this.binaryObject instanceof HeapBinaryObject && ((HeapBinaryObject)this.binaryObject).getBaseObject().length == this.numBytes) {
            return ((HeapBinaryObject)this.binaryObject).getBaseObject();
        }
        byte[] bytes = new byte[this.numBytes];
        BinaryOperations.copyMemory(this.binaryObject, this.offset, bytes, 0L, (long)this.numBytes);
        return bytes;
    }

    public String toString() {
        return new String(this.binaryObject.toBytes(), (int)this.offset, this.numBytes, StandardCharsets.UTF_8);
    }

    public IBinaryObject getBinaryObject() {
        return this.binaryObject;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryString)) {
            return false;
        }
        BinaryString that = (BinaryString)o;
        if (this.numBytes != that.numBytes) {
            return false;
        }
        return BinaryOperations.arrayEquals(this.binaryObject, this.offset, that.binaryObject, that.offset, this.numBytes);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = BinaryString.hashUnsafeBytes(this.binaryObject, this.offset, this.numBytes, 42);
        }
        return this.hashCode;
    }

    @Override
    public int compareTo(BinaryString other) {
        int i;
        int len = Math.min(this.numBytes, other.numBytes);
        int wordMax = len / 8 * 8;
        long otherOffset = other.offset;
        IBinaryObject otherBase = other.binaryObject;
        for (i = 0; i < wordMax; i += 8) {
            long right;
            long left = BinaryOperations.getLong(this.binaryObject, this.offset + (long)i);
            if (left == (right = BinaryOperations.getLong(otherBase, otherOffset + (long)i))) continue;
            if (IS_LITTLE_ENDIAN) {
                int y;
                int n = 0;
                long diff = left ^ right;
                int x = (int)diff;
                if (x == 0) {
                    x = (int)(diff >>> 32);
                    n = 32;
                }
                if ((y = x << 16) == 0) {
                    n += 16;
                } else {
                    x = y;
                }
                y = x << 8;
                if (y == 0) {
                    n += 8;
                }
                return (int)((left >>> n & 0xFFL) - (right >>> n & 0xFFL));
            }
            return Long.compareUnsigned(left, right);
        }
        for (i = wordMax; i < len; ++i) {
            int res = (this.getByte(i) & 0xFF) - (BinaryOperations.getByte(otherBase, otherOffset + (long)i) & 0xFF);
            if (res == 0) continue;
            return res;
        }
        return this.numBytes - other.numBytes;
    }

    public byte getByte(int i) {
        return BinaryOperations.getByte(this.binaryObject, this.offset + (long)i);
    }

    public BinaryString[] split(BinaryString pattern, int limit) {
        if (limit == 0) {
            limit = -1;
        }
        String[] splits = this.toString().split(pattern.toString(), limit);
        BinaryString[] res = new BinaryString[splits.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = BinaryString.fromString(splits[i]);
        }
        return res;
    }

    public int getLength() {
        int len = 0;
        for (int i = 0; i < this.numBytes; i += BinaryString.numBytesForFirstByte(this.getByte(i))) {
            ++len;
        }
        return len;
    }

    public boolean contains(BinaryString substring) {
        if (substring.numBytes == 0) {
            return true;
        }
        byte first = substring.getByte(0);
        for (int i = 0; i <= this.numBytes - substring.numBytes; ++i) {
            if (this.getByte(i) != first || !this.matchAt(substring, i)) continue;
            return true;
        }
        return false;
    }

    public static BinaryString concat(BinaryString ... inputs) {
        long totalLength = 0L;
        for (BinaryString input : inputs) {
            if (Objects.isNull(input)) continue;
            totalLength += (long)input.numBytes;
        }
        byte[] result = new byte[Math.toIntExact(totalLength)];
        int offset = 0;
        for (BinaryString input : inputs) {
            if (Objects.isNull(input)) continue;
            int len = input.numBytes;
            BinaryOperations.copyMemory(input.binaryObject, input.offset, result, (long)offset, (long)len);
            offset += len;
        }
        return BinaryString.fromBytes(result);
    }

    public static BinaryString concatWs(BinaryString separator, BinaryString ... inputs) {
        if (Objects.isNull(separator)) {
            separator = EMPTY_STRING;
        }
        long numInputBytes = 0L;
        int numInputs = inputs.length;
        for (BinaryString input : inputs) {
            if (!Objects.nonNull(input)) continue;
            numInputBytes += (long)input.numBytes;
        }
        int resultSize = Math.toIntExact(numInputBytes + (long)(numInputs - 1) * (long)separator.numBytes);
        byte[] result = new byte[resultSize];
        int offset = 0;
        int j = 0;
        for (int i = 0; i < inputs.length; ++i) {
            if (Objects.nonNull(inputs[i])) {
                int len = inputs[i].numBytes;
                BinaryOperations.copyMemory(inputs[i].binaryObject, inputs[i].offset, result, (long)offset, (long)len);
                offset += len;
            }
            if (++j >= numInputs) continue;
            BinaryOperations.copyMemory(separator.binaryObject, separator.offset, result, (long)offset, (long)separator.numBytes);
            offset += separator.numBytes;
        }
        return BinaryString.fromBytes(result);
    }

    public int indexOf(BinaryString s, int start) {
        int c;
        if (s.numBytes == 0) {
            return 0;
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += BinaryString.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        do {
            if (i + s.numBytes > this.numBytes) {
                return -1;
            }
            if (BinaryOperations.arrayEquals(this.binaryObject, this.offset + (long)i, s.binaryObject, s.offset, s.numBytes)) {
                return c;
            }
            i += BinaryString.numBytesForFirstByte(this.getByte(i));
            ++c;
        } while (i < this.numBytes);
        return -1;
    }

    public boolean matchAt(BinaryString s, int pos) {
        if (s.numBytes + pos > this.numBytes || pos < 0) {
            return false;
        }
        return BinaryOperations.arrayEquals(this.binaryObject, this.offset + (long)pos, s.binaryObject, s.offset, s.numBytes);
    }

    public boolean startsWith(BinaryString prefix) {
        return this.matchAt(prefix, 0);
    }

    public boolean endsWith(BinaryString suffix) {
        return this.matchAt(suffix, this.numBytes - suffix.numBytes);
    }

    private static int numBytesForFirstByte(byte b) {
        int offset = b & 0xFF;
        byte numBytes = bytesOfCodePointInUTF8[offset];
        return numBytes == 0 ? (byte)1 : numBytes;
    }

    public BinaryString substring(int start) {
        return this.substring(start, this.getLength());
    }

    public BinaryString substring(int start, int end) {
        int c;
        if (end <= start || start >= this.numBytes) {
            return EMPTY_STRING;
        }
        int i = 0;
        for (c = 0; i < this.numBytes && c < start; i += BinaryString.numBytesForFirstByte(this.getByte(i)), ++c) {
        }
        int j = i;
        while (i < this.numBytes && c < end) {
            i += BinaryString.numBytesForFirstByte(this.getByte(i));
            ++c;
        }
        if (i > j) {
            byte[] bytes = new byte[i - j];
            BinaryOperations.copyMemory(this.binaryObject, this.offset + (long)j, bytes, 0L, (long)(i - j));
            return BinaryString.fromBytes(bytes);
        }
        return EMPTY_STRING;
    }

    public BinaryString reverse() {
        byte[] bytes = new byte[this.numBytes];
        for (int i = 0; i < this.numBytes; ++i) {
            bytes[i] = this.getByte(this.numBytes - i - 1);
        }
        return BinaryString.fromBytes(bytes);
    }

    public void write(Kryo kryo, Output output) {
        output.writeInt(this.numBytes);
        output.write(this.binaryObject.toBytes(), (int)this.offset, this.numBytes);
    }

    public void read(Kryo kryo, Input input) {
        int size = input.readInt();
        byte[] bytes = new byte[size];
        input.read(bytes);
        this.binaryObject = HeapBinaryObject.of(bytes);
        this.offset = 0L;
        this.numBytes = bytes.length;
    }

    private static int hashUnsafeBytes(IBinaryObject base, long offset, int lengthInBytes, int seed) {
        int lengthAligned = lengthInBytes - lengthInBytes % 4;
        int h1 = BinaryString.hashBytesByInt(base, offset, lengthAligned, seed);
        for (int i = lengthAligned; i < lengthInBytes; ++i) {
            byte halfWord = BinaryOperations.getByte(base, offset + (long)i);
            int k1 = BinaryString.mixK1(halfWord);
            h1 = BinaryString.mixH1(h1, k1);
        }
        return BinaryString.fmix(h1, lengthInBytes);
    }

    private static int hashBytesByInt(IBinaryObject base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 4 == 0);
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = BinaryOperations.getInt(base, offset + (long)i);
            if (!IS_LITTLE_ENDIAN) {
                halfWord = Integer.reverseBytes(halfWord);
            }
            h1 = BinaryString.mixH1(h1, BinaryString.mixK1(halfWord));
        }
        return h1;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

