/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.binary;

import com.antgroup.geaflow.common.binary.BinaryOperations;
import com.antgroup.geaflow.common.binary.IBinaryObject;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.Arrays;

public class HeapBinaryObject
implements IBinaryObject {
    private byte[] bytes;

    public HeapBinaryObject() {
    }

    private HeapBinaryObject(byte[] bytes) {
        this.bytes = bytes;
    }

    public static HeapBinaryObject of(byte[] bytes) {
        return new HeapBinaryObject(bytes);
    }

    public byte[] getBaseObject() {
        return this.bytes;
    }

    @Override
    public long getAbsoluteAddress(long address) {
        if (address < 0L || address >= (long)this.size()) {
            throw new GeaflowRuntimeException("Illegal address: " + address + ", is out of visit range[0," + this.size() + ")");
        }
        return (long)BinaryOperations.BYTE_ARRAY_OFFSET + address;
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    @Override
    public void release() {
        this.bytes = null;
    }

    @Override
    public boolean isReleased() {
        return this.bytes == null;
    }

    @Override
    public byte[] toBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HeapBinaryObject)) {
            return false;
        }
        HeapBinaryObject that = (HeapBinaryObject)o;
        return Arrays.equals(this.bytes, that.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public void write(Kryo kryo, Output output) {
        output.writeVarInt(this.bytes.length, true);
        output.write(this.bytes);
    }

    public void read(Kryo kryo, Input input) {
        int length = input.readVarInt(true);
        this.bytes = new byte[length];
        input.read(this.bytes);
    }

    public String toString() {
        return "HeapBinaryObject{bytes=" + Arrays.toString(this.bytes) + '}';
    }
}

