/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.blocking.map;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class BlockingMap<K, V> {
    private Map<K, ArrayBlockingQueue<V>> map = new ConcurrentHashMap<K, ArrayBlockingQueue<V>>();

    private BlockingQueue<V> getQueue(K key) {
        return this.map.computeIfAbsent(key, k -> new ArrayBlockingQueue(1));
    }

    public void put(K key, V value) {
        if (!this.getQueue(key).offer(value)) {
            throw new GeaflowRuntimeException(String.format("BlockingMap offer element (%s, %s) failed.", key, value));
        }
    }

    public V get(K key) throws InterruptedException {
        return this.getQueue(key).take();
    }

    public V get(K key, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getQueue(key).poll(timeout, unit);
    }
}

