/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.config;

import com.antgroup.geaflow.common.config.ConfigHelper;
import com.antgroup.geaflow.common.config.ConfigKey;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Configuration
implements Serializable {
    private String masterId;
    private final Map<String, String> config;

    public Configuration() {
        this.config = new HashMap<String, String>();
    }

    public Configuration(Map<String, String> config) {
        this.config = config;
    }

    public Map<String, String> getConfigMap() {
        return this.config;
    }

    public String getMasterId() {
        return this.masterId;
    }

    public void setMasterId(String masterId) {
        this.masterId = masterId;
    }

    public boolean contains(ConfigKey key) {
        return this.config.containsKey(key.getKey());
    }

    public boolean contains(String key) {
        return this.config.containsKey(key);
    }

    public void put(String key, String value) {
        this.config.put(key, value);
    }

    public void put(ConfigKey key, String value) {
        this.config.put(key.getKey(), value);
    }

    public void putAll(Map<String, String> map) {
        this.config.putAll(map);
    }

    public String getString(ConfigKey configKey) {
        return Configuration.getString(configKey, this.config);
    }

    public String getString(ConfigKey configKey, String defaultValue) {
        return Configuration.getString(configKey, defaultValue, this.config);
    }

    public String getString(String configKey) {
        return this.config.get(configKey);
    }

    public String getString(String configKey, String defaultValue) {
        return ConfigHelper.getStringOrDefault(this.config, configKey, defaultValue);
    }

    public int getInteger(ConfigKey configKey) {
        return Configuration.getInteger(configKey, this.config);
    }

    public int getInteger(ConfigKey configKey, int defaultValue) {
        return Configuration.getInteger(configKey, defaultValue, this.config);
    }

    public int getInteger(String configKey, int defaultValue) {
        return ConfigHelper.getIntegerOrDefault(this.config, configKey, defaultValue);
    }

    public double getDouble(ConfigKey configKey) {
        return Configuration.getDouble(configKey, this.config);
    }

    public boolean getBoolean(ConfigKey configKey) {
        return Configuration.getBoolean(configKey, this.config);
    }

    public long getLong(ConfigKey configKey) {
        return Configuration.getLong(configKey, this.config);
    }

    public long getLong(String configKey, long defaultValue) {
        return ConfigHelper.getLongOrDefault(this.config, configKey, defaultValue);
    }

    public static String getString(ConfigKey configKey, Map<String, String> config) {
        if (configKey.getDefaultValue() != null) {
            return ConfigHelper.getStringOrDefault(config, configKey.getKey(), String.valueOf(configKey.getDefaultValue()));
        }
        return ConfigHelper.getString(config, configKey.getKey());
    }

    public static String getString(ConfigKey configKey, String defaultValue, Map<String, String> config) {
        return ConfigHelper.getStringOrDefault(config, configKey.getKey(), defaultValue);
    }

    public static boolean getBoolean(ConfigKey configKey, Map<String, String> config) {
        if (configKey.getDefaultValue() != null) {
            return ConfigHelper.getBooleanOrDefault(config, configKey.getKey(), (Boolean)configKey.getDefaultValue());
        }
        return ConfigHelper.getBoolean(config, configKey.getKey());
    }

    public static int getInteger(ConfigKey configKey, Map<String, String> config) {
        if (configKey.getDefaultValue() != null) {
            return ConfigHelper.getIntegerOrDefault(config, configKey.getKey(), (Integer)configKey.getDefaultValue());
        }
        return ConfigHelper.getInteger(config, configKey.getKey());
    }

    public static int getInteger(ConfigKey configKey, int defaultValue, Map<String, String> config) {
        return ConfigHelper.getIntegerOrDefault(config, configKey.getKey(), defaultValue);
    }

    public static long getLong(ConfigKey configKey, Map<String, String> config) {
        if (configKey.getDefaultValue() != null) {
            return ConfigHelper.getLongOrDefault(config, configKey.getKey(), (Long)configKey.getDefaultValue());
        }
        return ConfigHelper.getLong(config, configKey.getKey());
    }

    public static long getLong(ConfigKey configKey, long defaultValue, Map<String, String> config) {
        return ConfigHelper.getLongOrDefault(config, configKey.getKey(), defaultValue);
    }

    public static double getDouble(ConfigKey configKey, Map<String, String> config) {
        if (configKey.getDefaultValue() != null) {
            return ConfigHelper.getDoubleOrDefault(config, configKey.getKey(), (Double)configKey.getDefaultValue());
        }
        return ConfigHelper.getDouble(config, configKey.getKey());
    }

    public String toString() {
        return "Configuration{" + this.config + '}';
    }
}

