/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder;

import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.encoder.impl.EnumEncoder;
import com.antgroup.geaflow.common.encoder.impl.GenericArrayEncoder;
import com.antgroup.geaflow.common.encoder.impl.PojoEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.tuple.Triple;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncoderResolver.class);
    private static final String EMPTY = "";
    private static final String UNDERLINE = "_";
    private static final String METHOD_READ_OBJECT = "readObject";
    private static final String METHOD_WRITE_OBJECT = "writeObject";

    public static IEncoder<?> resolveClass(Class<?> clazz) {
        return EncoderResolver.resolveType(clazz);
    }

    public static IEncoder<?> resolveType(Type type) {
        if (EncoderResolver.isClassType(type)) {
            Class<?> clazz = EncoderResolver.typeToClass(type);
            if (clazz == Object.class) {
                return null;
            }
            if (clazz == Class.class) {
                return null;
            }
            if (Modifier.isInterface(clazz.getModifiers())) {
                return null;
            }
            if (Encoders.PRIMITIVE_ENCODER_MAP.containsKey(clazz)) {
                return Encoders.PRIMITIVE_ENCODER_MAP.get(clazz);
            }
            if (Tuple.class.isAssignableFrom(clazz)) {
                return EncoderResolver.resolveTuple(type);
            }
            if (Triple.class.isAssignableFrom(clazz)) {
                return EncoderResolver.resolveTriple(type);
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return new EnumEncoder(clazz);
            }
            if (clazz.isArray()) {
                if (Encoders.PRIMITIVE_ARR_ENCODER_MAP.containsKey(clazz)) {
                    return Encoders.PRIMITIVE_ARR_ENCODER_MAP.get(clazz);
                }
                Class<?> componentClass = clazz.getComponentType();
                IEncoder<?> componentEncoder = EncoderResolver.resolveClass(clazz.getComponentType());
                if (componentEncoder != null) {
                    GenericArrayEncoder.ArrayConstructor constructor = length -> (Object[])Array.newInstance(componentClass, length);
                    return new GenericArrayEncoder(componentEncoder, constructor);
                }
            }
            return EncoderResolver.resolvePojo(type);
        }
        return null;
    }

    public static IEncoder<?> resolveTuple(Type type) {
        ArrayList<ParameterizedType> subTypeTree = new ArrayList<ParameterizedType>();
        Type curType = type;
        while (!EncoderResolver.isClassType(curType) || !EncoderResolver.typeToClass(curType).equals(Tuple.class)) {
            if (curType instanceof ParameterizedType) {
                subTypeTree.add((ParameterizedType)curType);
            }
            curType = EncoderResolver.typeToClass(curType).getGenericSuperclass();
        }
        if (curType instanceof Class) {
            LOGGER.warn("Tuple needs to be parameterized with generics");
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)curType;
        subTypeTree.add(parameterizedType);
        IEncoder<?>[] subEncoders = EncoderResolver.resolveSubEncoder(subTypeTree, parameterizedType);
        if (subEncoders == null || subEncoders.length != 2) {
            return null;
        }
        if (EncoderResolver.countClassFields(EncoderResolver.typeToClass(type)) != subEncoders.length) {
            LOGGER.warn("tuple filed num does not match encoder num");
            return null;
        }
        return Encoders.tuple(subEncoders[0], subEncoders[1]);
    }

    public static IEncoder<?> resolveTriple(Type type) {
        ArrayList<ParameterizedType> subTypeTree = new ArrayList<ParameterizedType>();
        Type curType = type;
        while (!EncoderResolver.isClassType(curType) || !EncoderResolver.typeToClass(curType).equals(Triple.class)) {
            if (curType instanceof ParameterizedType) {
                subTypeTree.add((ParameterizedType)curType);
            }
            curType = EncoderResolver.typeToClass(curType).getGenericSuperclass();
        }
        if (curType instanceof Class) {
            LOGGER.warn("Tuple needs to be parameterized with generics");
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)curType;
        subTypeTree.add(parameterizedType);
        IEncoder<?>[] subEncoders = EncoderResolver.resolveSubEncoder(subTypeTree, parameterizedType);
        if (subEncoders == null || subEncoders.length != 3) {
            return null;
        }
        if (EncoderResolver.countClassFields(EncoderResolver.typeToClass(type)) != subEncoders.length) {
            LOGGER.warn("triple filed num does not match encoder num");
            return null;
        }
        return Encoders.triple(subEncoders[0], subEncoders[1], subEncoders[2]);
    }

    private static IEncoder<?>[] resolveSubEncoder(List<ParameterizedType> typeTree, ParameterizedType parameterizedType) {
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        IEncoder[] encoders = new IEncoder[typeArguments.length];
        for (int i = 0; i < typeArguments.length; ++i) {
            IEncoder<?> encoder;
            Type typeArgument;
            Type concreteType = typeArgument = typeArguments[i];
            if (typeArgument instanceof TypeVariable) {
                concreteType = EncoderResolver.getConcreteTypeofTypeVariable(typeTree, (TypeVariable)typeArgument);
            }
            if ((encoder = EncoderResolver.resolveType(concreteType)) == null) {
                return null;
            }
            encoders[i] = encoder;
        }
        return encoders;
    }

    public static IEncoder<?> resolvePojo(Type type) {
        if (EncoderResolver.isClassType(type)) {
            Class<?> clazz = EncoderResolver.typeToClass(type);
            try {
                EncoderResolver.analysisPojo(clazz);
            }
            catch (GeaflowRuntimeException e) {
                return null;
            }
            return PojoEncoder.build(clazz);
        }
        return null;
    }

    @VisibleForTesting
    protected static <T> void analysisPojo(Class<T> clazz) {
        Constructor<T> defaultConstructor;
        Method[] methods;
        if (!Modifier.isPublic(clazz.getModifiers())) {
            String msg = "Class [" + clazz.getName() + "] is not public, it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            String msg = "Class [" + clazz.getName() + "] is abstract or an interface,it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        if (clazz.getSuperclass() != Object.class) {
            String msg = "Class [" + clazz.getName() + "] does not extends Object directly, it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            if (!METHOD_READ_OBJECT.equals(method.getName()) && !METHOD_WRITE_OBJECT.equals(method.getName())) continue;
            String msg = "Class [" + clazz.getName() + "] contains custom serialization methods we do not call, it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        try {
            defaultConstructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String msg = "Class [" + clazz.getName() + "] has no default constructor, it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg), e);
        }
        if (!Modifier.isPublic(defaultConstructor.getModifiers())) {
            String msg = "The default constructor of [" + clazz + "] is not Public, it cannot be used as a POJO type";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        List<Field> fields = EncoderResolver.getPojoFields(clazz);
        if (fields.isEmpty()) {
            String msg = "Class [" + clazz.getName() + "] has no declared fields";
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
        }
        for (Field field : fields) {
            EncoderResolver.checkValidPojoField(field, clazz);
        }
    }

    private static void checkValidPojoField(Field f, Class<?> clazz) {
        if (!Modifier.isPublic(f.getModifiers())) {
            String msg;
            String fieldNameLow = f.getName().toLowerCase().replaceAll(UNDERLINE, EMPTY);
            Type fieldType = f.getGenericType();
            Class<?> fieldTypeWrapper = f.getType();
            if (fieldTypeWrapper.isPrimitive()) {
                fieldTypeWrapper = Encoders.PRIMITIVE_WRAPPER_MAP.get(fieldTypeWrapper);
            }
            if (fieldType instanceof TypeVariable) {
                String msg2 = "do not support generics yet";
                throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg2));
            }
            boolean hasGetter = false;
            boolean hasSetter = false;
            for (Method m : clazz.getMethods()) {
                String methodNameLow = m.getName().toLowerCase().replaceAll(UNDERLINE, EMPTY);
                if (!hasGetter && (methodNameLow.equals("get" + fieldNameLow) || methodNameLow.equals("is" + fieldNameLow)) && m.getParameterTypes().length == 0 && (m.getGenericReturnType().equals(fieldType) || m.getReturnType().equals(fieldTypeWrapper))) {
                    hasGetter = true;
                }
                if (hasSetter || !methodNameLow.equals("set" + fieldNameLow) || m.getParameterTypes().length != 1 || !m.getGenericParameterTypes()[0].equals(fieldType) && !m.getParameterTypes()[0].equals(fieldTypeWrapper) || !m.getReturnType().equals(Void.TYPE) && !m.getReturnType().equals(clazz)) continue;
                hasSetter = true;
            }
            if (!hasGetter) {
                msg = clazz + " does not contain a getter for field " + f.getName();
                throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
            }
            if (!hasSetter) {
                msg = clazz + " does not contain a setter for field " + f.getName();
                throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
            }
        }
    }

    public static IEncoder<?> resolveFunction(Class<?> baseClass, Object function) {
        return EncoderResolver.resolveFunction(baseClass, function, 0);
    }

    public static IEncoder<?> resolveFunction(Class<?> baseClass, Object function, int typeParaIdx) {
        if (baseClass == Object.class) {
            return null;
        }
        ArrayList<ParameterizedType> typeTree = new ArrayList<ParameterizedType>();
        Class<?> funcClass = function.getClass();
        Type paraType = EncoderResolver.extractParaType(typeTree, baseClass, funcClass, typeParaIdx);
        if (paraType instanceof TypeVariable) {
            Type concreteType = EncoderResolver.getConcreteTypeofTypeVariable(typeTree, (TypeVariable)paraType);
            return EncoderResolver.resolveType(concreteType);
        }
        return EncoderResolver.resolveType(paraType);
    }

    private static Type extractParaType(List<ParameterizedType> typeTree, Class<?> baseClass, Class<?> functionClass, int typeParaIdx) {
        Type[] gInterfaces;
        for (Type gInterface : gInterfaces = functionClass.getGenericInterfaces()) {
            Type type = EncoderResolver.extractParaTypeFromGeneric(typeTree, baseClass, gInterface, typeParaIdx);
            if (type == null) continue;
            return type;
        }
        Type gClass = functionClass.getGenericSuperclass();
        return EncoderResolver.extractParaTypeFromGeneric(typeTree, baseClass, gClass, typeParaIdx);
    }

    private static Type extractParaTypeFromGeneric(List<ParameterizedType> typeTree, Class<?> baseClass, Type type, int typeParaIdx) {
        Class clazz;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            typeTree.add(parameterizedType);
            Class rawType = (Class)parameterizedType.getRawType();
            if (baseClass.equals(rawType)) {
                return parameterizedType.getActualTypeArguments()[typeParaIdx];
            }
            if (baseClass.isAssignableFrom(rawType)) {
                return EncoderResolver.extractParaType(typeTree, baseClass, rawType, typeParaIdx);
            }
        }
        if (type instanceof Class && baseClass.isAssignableFrom(clazz = (Class)type)) {
            return EncoderResolver.extractParaType(typeTree, baseClass, clazz, typeParaIdx);
        }
        return null;
    }

    private static Type getConcreteTypeofTypeVariable(List<ParameterizedType> typeTree, TypeVariable<?> typeVar) {
        TypeVariable curTypeVar = typeVar;
        for (int i = typeTree.size() - 1; i >= 0; --i) {
            ParameterizedType curType = typeTree.get(i);
            Class rawType = (Class)curType.getRawType();
            TypeVariable<Class<T>>[] rawTypeParameters = rawType.getTypeParameters();
            for (int idx = 0; idx < rawTypeParameters.length; ++idx) {
                TypeVariable rawTypeVar = rawType.getTypeParameters()[idx];
                if (!curTypeVar.getName().equals(rawTypeVar.getName()) || !curTypeVar.getGenericDeclaration().equals(rawTypeVar.getGenericDeclaration())) continue;
                Type actualTypeArgument = curType.getActualTypeArguments()[idx];
                if (actualTypeArgument instanceof TypeVariable) {
                    curTypeVar = (TypeVariable)actualTypeArgument;
                    continue;
                }
                return actualTypeArgument;
            }
        }
        return curTypeVar;
    }

    public static boolean isClassType(Type t) {
        return t instanceof Class || t instanceof ParameterizedType;
    }

    public static Class<?> typeToClass(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("Cannot convert type to class"));
    }

    private static int countClassFields(Class<?> clazz) {
        int fieldCount = 0;
        for (Field field : clazz.getFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            ++fieldCount;
        }
        return fieldCount;
    }

    private static List<Field> getPojoFields(Class<?> clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())).collect(Collectors.toList());
    }
}

