/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.function.IntFunction;

public class GenericArrayEncoder<T>
extends AbstractEncoder<T[]> {
    private final IEncoder<T> encoder;
    private final ArrayConstructor<T> constructor;

    public GenericArrayEncoder(IEncoder<T> encoder, ArrayConstructor<T> constructor) {
        this.encoder = encoder;
        this.constructor = constructor;
    }

    @Override
    public void init(Configuration config) {
        this.encoder.init(config);
    }

    @Override
    public void encode(T[] data, OutputStream outputStream) throws IOException {
        if (data == null) {
            Encoders.INTEGER.encode(0, outputStream);
            return;
        }
        int lenToWrite = data.length + 1;
        if (lenToWrite < 0) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("arr is too big"));
        }
        Encoders.INTEGER.encode(lenToWrite, outputStream);
        for (T datum : data) {
            this.encoder.encode(datum, outputStream);
        }
    }

    @Override
    public T[] decode(InputStream inputStream) throws IOException {
        int flag = Encoders.INTEGER.decode(inputStream);
        if (flag == 0) {
            return null;
        }
        int length = flag - 1;
        Object[] arr = (Object[])this.constructor.apply(length);
        for (int i = 0; i < length; ++i) {
            arr[i] = this.encoder.decode(inputStream);
        }
        return arr;
    }

    @FunctionalInterface
    public static interface ArrayConstructor<T>
    extends IntFunction<T[]>,
    Serializable {
    }
}

