/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntegerArrEncoder
extends AbstractEncoder<int[]> {
    public static final IntegerArrEncoder INSTANCE = new IntegerArrEncoder();

    @Override
    public void encode(int[] data, OutputStream outputStream) throws IOException {
        if (data == null) {
            Encoders.INTEGER.encode(0, outputStream);
            return;
        }
        int lenToWrite = data.length + 1;
        if (lenToWrite < 0) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("arr is too big"));
        }
        Encoders.INTEGER.encode(lenToWrite, outputStream);
        for (int datum : data) {
            Encoders.INTEGER.encode(datum, outputStream);
        }
    }

    @Override
    public int[] decode(InputStream inputStream) throws IOException {
        int flag = Encoders.INTEGER.decode(inputStream);
        if (flag == 0) {
            return null;
        }
        int length = flag - 1;
        int[] arr = new int[length];
        for (int i = 0; i < length; ++i) {
            arr[i] = Encoders.INTEGER.decode(inputStream);
        }
        return arr;
    }
}

