/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IntegerEncoder
extends AbstractEncoder<Integer> {
    public static final IntegerEncoder INSTANCE = new IntegerEncoder();

    @Override
    public void encode(Integer data, OutputStream outputStream) throws IOException {
        if (data >= 0 && data < 128) {
            outputStream.write(data);
            return;
        }
        int value = data;
        int varInt = value & 0x7F;
        varInt |= 0x80;
        varInt |= ((value >>>= 7) & 0x7F) << 8;
        if ((value >>>= 7) == 0) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            return;
        }
        varInt |= 0x8000;
        varInt |= (value & 0x7F) << 16;
        if ((value >>>= 7) == 0) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            outputStream.write(varInt >> 16);
            return;
        }
        varInt |= 0x800000;
        varInt |= (value & 0x7F) << 24;
        if ((value >>>= 7) == 0) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            outputStream.write(varInt >> 16);
            outputStream.write(varInt >> 24);
            return;
        }
        outputStream.write(varInt |= Integer.MIN_VALUE);
        outputStream.write(varInt >> 8);
        outputStream.write(varInt >> 16);
        outputStream.write(varInt >> 24);
        outputStream.write(value);
    }

    @Override
    public Integer decode(InputStream inputStream) throws IOException {
        int b = inputStream.read();
        int result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = inputStream.read();
            result |= (b & 0x7F) << 7;
            if ((b & 0x80) != 0) {
                b = inputStream.read();
                result |= (b & 0x7F) << 14;
                if ((b & 0x80) != 0) {
                    b = inputStream.read();
                    result |= (b & 0x7F) << 21;
                    if ((b & 0x80) != 0) {
                        b = inputStream.read();
                        result |= (b & 0x7F) << 28;
                    }
                }
            }
        }
        return result;
    }
}

