/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class LongEncoder
extends AbstractEncoder<Long> {
    public static final LongEncoder INSTANCE = new LongEncoder();

    @Override
    public void encode(Long data, OutputStream outputStream) throws IOException {
        if (data >= 0L && data < 128L) {
            outputStream.write(data.intValue());
            return;
        }
        long value = data;
        int varInt = (int)(value & 0x7FL);
        varInt |= 0x80;
        varInt = (int)((long)varInt | ((value >>>= 7) & 0x7FL) << 8);
        if ((value >>>= 7) == 0L) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            return;
        }
        varInt |= 0x8000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 16);
        if ((value >>>= 7) == 0L) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            outputStream.write(varInt >> 16);
            return;
        }
        varInt |= 0x800000;
        varInt = (int)((long)varInt | (value & 0x7FL) << 24);
        if ((value >>>= 7) == 0L) {
            outputStream.write(varInt);
            outputStream.write(varInt >> 8);
            outputStream.write(varInt >> 16);
            outputStream.write(varInt >> 24);
            return;
        }
        long varLong = (long)(varInt |= Integer.MIN_VALUE) & 0xFFFFFFFFL;
        varLong |= (value & 0x7FL) << 32;
        if ((value >>>= 7) == 0L) {
            outputStream.write((int)varLong);
            outputStream.write((int)(varLong >> 8));
            outputStream.write((int)(varLong >> 16));
            outputStream.write((int)(varLong >> 24));
            outputStream.write((int)(varLong >> 32));
            return;
        }
        varLong |= 0x8000000000L;
        varLong |= (value & 0x7FL) << 40;
        if ((value >>>= 7) == 0L) {
            outputStream.write((int)varLong);
            outputStream.write((int)(varLong >> 8));
            outputStream.write((int)(varLong >> 16));
            outputStream.write((int)(varLong >> 24));
            outputStream.write((int)(varLong >> 32));
            outputStream.write((int)(varLong >> 40));
            return;
        }
        varLong |= 0x800000000000L;
        varLong |= (value & 0x7FL) << 48;
        if ((value >>>= 7) == 0L) {
            outputStream.write((int)varLong);
            outputStream.write((int)(varLong >> 8));
            outputStream.write((int)(varLong >> 16));
            outputStream.write((int)(varLong >> 24));
            outputStream.write((int)(varLong >> 32));
            outputStream.write((int)(varLong >> 40));
            outputStream.write((int)(varLong >> 48));
            return;
        }
        varLong |= 0x80000000000000L;
        varLong |= (value & 0x7FL) << 56;
        if ((value >>>= 7) == 0L) {
            outputStream.write((int)varLong);
            outputStream.write((int)(varLong >> 8));
            outputStream.write((int)(varLong >> 16));
            outputStream.write((int)(varLong >> 24));
            outputStream.write((int)(varLong >> 32));
            outputStream.write((int)(varLong >> 40));
            outputStream.write((int)(varLong >> 48));
            outputStream.write((int)(varLong >> 56));
            return;
        }
        outputStream.write((int)(varLong |= Long.MIN_VALUE));
        outputStream.write((int)(varLong >> 8));
        outputStream.write((int)(varLong >> 16));
        outputStream.write((int)(varLong >> 24));
        outputStream.write((int)(varLong >> 32));
        outputStream.write((int)(varLong >> 40));
        outputStream.write((int)(varLong >> 48));
        outputStream.write((int)(varLong >> 56));
        outputStream.write((int)value);
    }

    @Override
    public Long decode(InputStream inputStream) throws IOException {
        int b = inputStream.read();
        long result = b & 0x7F;
        if ((b & 0x80) != 0) {
            b = inputStream.read();
            result |= (long)((b & 0x7F) << 7);
            if ((b & 0x80) != 0) {
                b = inputStream.read();
                result |= (long)((b & 0x7F) << 14);
                if ((b & 0x80) != 0) {
                    b = inputStream.read();
                    result |= (long)((b & 0x7F) << 21);
                    if ((b & 0x80) != 0) {
                        b = inputStream.read();
                        result |= (long)(b & 0x7F) << 28;
                        if ((b & 0x80) != 0) {
                            b = inputStream.read();
                            result |= (long)(b & 0x7F) << 35;
                            if ((b & 0x80) != 0) {
                                b = inputStream.read();
                                result |= (long)(b & 0x7F) << 42;
                                if ((b & 0x80) != 0) {
                                    b = inputStream.read();
                                    result |= (long)(b & 0x7F) << 49;
                                    if ((b & 0x80) != 0) {
                                        b = inputStream.read();
                                        result |= (long)b << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }
}

