/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.encoder.EncoderResolver;
import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PojoEncoder<T>
extends AbstractEncoder<T> {
    private static final Map<Class<?>, PojoField[]> POJO_FIELDS_CACHE = new HashMap();
    private final Class<T> clazz;
    private PojoField[] pojoFields;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PojoField[] getPojoFields(Class<?> clazz) {
        if (POJO_FIELDS_CACHE.containsKey(clazz)) return POJO_FIELDS_CACHE.get(clazz);
        Class<PojoEncoder> clazz2 = PojoEncoder.class;
        synchronized (PojoEncoder.class) {
            if (POJO_FIELDS_CACHE.containsKey(clazz)) return POJO_FIELDS_CACHE.get(clazz);
            List fields = Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isTransient(field.getModifiers()) && !Modifier.isStatic(field.getModifiers())).sorted(Comparator.comparing(Field::getName)).peek(f -> f.setAccessible(true)).collect(Collectors.toList());
            ArrayList<PojoField> pojoFields = new ArrayList<PojoField>();
            for (Field field2 : fields) {
                Class<?> fieldType = field2.getType();
                IEncoder<?> encoder = EncoderResolver.resolveClass(fieldType);
                pojoFields.add(PojoField.build(field2, encoder));
            }
            PojoField[] fieldsArr = (PojoField[])pojoFields.stream().peek(f -> f.getField().setAccessible(true)).sorted(Comparator.comparing(f -> f.getField().getName())).toArray(PojoField[]::new);
            POJO_FIELDS_CACHE.put(clazz, fieldsArr);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return POJO_FIELDS_CACHE.get(clazz);
        }
    }

    public static <T> PojoEncoder<T> build(Class<T> clazz) {
        return new PojoEncoder<T>(clazz);
    }

    public PojoEncoder(Class<T> clazz) {
        this.clazz = clazz;
    }

    @Override
    public void init(Configuration config) {
        if (this.pojoFields == null) {
            this.pojoFields = PojoEncoder.getPojoFields(this.clazz);
        }
    }

    @Override
    public void encode(T data, OutputStream outputStream) throws IOException {
        if (data == null) {
            Encoders.INTEGER.encode(0, outputStream);
            return;
        }
        Encoders.INTEGER.encode(1, outputStream);
        try {
            for (int i = 0; i < this.pojoFields.length; ++i) {
                PojoField pojoField = this.pojoFields[i];
                Object value = pojoField.getField().get(data);
                if (value == null) {
                    Encoders.INTEGER.encode(0, outputStream);
                    continue;
                }
                Encoders.INTEGER.encode(1, outputStream);
                pojoField.getEncoder().encode(value, outputStream);
            }
        }
        catch (IllegalAccessException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(e.getMessage()), e);
        }
    }

    @Override
    public T decode(InputStream inputStream) throws IOException {
        if (Encoders.INTEGER.decode(inputStream) == 0) {
            return null;
        }
        try {
            T obj = this.clazz.newInstance();
            for (int i = 0; i < this.pojoFields.length; ++i) {
                int flag = Encoders.INTEGER.decode(inputStream);
                if (flag != 1) continue;
                PojoField pojoField = this.pojoFields[i];
                Object value = pojoField.getEncoder().decode(inputStream);
                pojoField.getField().set(obj, value);
            }
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(e.getMessage()), e);
        }
    }

    public static class PojoField
    implements Serializable {
        private final Field field;
        private final IEncoder<?> encoder;

        public static PojoField build(Field field, IEncoder<?> encoder) {
            return new PojoField(field, encoder);
        }

        public PojoField(Field field, IEncoder<?> encoder) {
            this.field = field;
            this.encoder = encoder;
        }

        public Field getField() {
            return this.field;
        }

        public IEncoder<?> getEncoder() {
            return this.encoder;
        }
    }
}

