/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.encoder.impl.IntegerEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StringEncoder
extends AbstractEncoder<String> {
    public static final StringEncoder INSTANCE = new StringEncoder();
    private static final int NULL = 0;

    @Override
    public void encode(String data, OutputStream outputStream) throws IOException {
        if (data == null) {
            Encoders.INTEGER.encode(0, outputStream);
            return;
        }
        int lenToWrite = data.length() + 1;
        if (lenToWrite < 0) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError("string is too long"));
        }
        byte[] bytes = data.getBytes();
        IntegerEncoder.INSTANCE.encode(bytes.length + 1, outputStream);
        outputStream.write(bytes);
    }

    @Override
    public String decode(InputStream inputStream) throws IOException {
        int length = Encoders.INTEGER.decode(inputStream);
        if (length == 0) {
            return null;
        }
        byte[] bytes = new byte[length - 1];
        inputStream.read(bytes);
        return new String(bytes);
    }
}

