/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.encoder.impl;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.encoder.Encoders;
import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.encoder.impl.AbstractEncoder;
import com.antgroup.geaflow.common.tuple.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TupleEncoder<F0, F1>
extends AbstractEncoder<Tuple<F0, F1>> {
    private final IEncoder<F0> encoder0;
    private final IEncoder<F1> encoder1;

    public TupleEncoder(IEncoder<F0> encoder0, IEncoder<F1> encoder1) {
        this.encoder0 = encoder0;
        this.encoder1 = encoder1;
    }

    @Override
    public void init(Configuration config) {
        this.encoder0.init(config);
        this.encoder1.init(config);
    }

    @Override
    public void encode(Tuple<F0, F1> data, OutputStream outputStream) throws IOException {
        int flag = data == null ? 0 : 1;
        Encoders.INTEGER.encode(flag, outputStream);
        if (flag == 0) {
            return;
        }
        this.encoder0.encode(data.f0, outputStream);
        this.encoder1.encode(data.f1, outputStream);
    }

    @Override
    public Tuple<F0, F1> decode(InputStream inputStream) throws IOException {
        int flag = Encoders.INTEGER.decode(inputStream);
        if (flag == 0) {
            return null;
        }
        F0 f0 = this.encoder0.decode(inputStream);
        F1 f1 = this.encoder1.decode(inputStream);
        return Tuple.of(f0, f1);
    }
}

