/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.metric;

import java.io.Serializable;

public class CycleMetrics
implements Serializable {
    private String name;
    private String pipelineName;
    private String opName;
    private long duration;
    private long startTime;
    private long totalTasks;
    private int slowestTask;
    private long slowestTaskExecuteTime;
    private long inputRecords;
    private long inputKb;
    private long outputRecords;
    private long outputKb;
    private long avgGcTime;
    private long avgExecuteTime;

    public CycleMetrics(String name, String pipelineName, String opName) {
        this.name = name;
        this.pipelineName = pipelineName;
        this.opName = opName;
    }

    public String getName() {
        return this.name;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getOpName() {
        return this.opName;
    }

    public void setOpName(String opName) {
        this.opName = opName;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getTotalTasks() {
        return this.totalTasks;
    }

    public void setTotalTasks(long totalTasks) {
        this.totalTasks = totalTasks;
    }

    public int getSlowestTask() {
        return this.slowestTask;
    }

    public void setSlowestTask(int slowestTask) {
        this.slowestTask = slowestTask;
    }

    public long getAvgGcTime() {
        return this.avgGcTime;
    }

    public void setAvgGcTime(long avgGcTime) {
        this.avgGcTime = avgGcTime;
    }

    public long getAvgExecuteTime() {
        return this.avgExecuteTime;
    }

    public void setAvgExecuteTime(long avgExecuteTime) {
        this.avgExecuteTime = avgExecuteTime;
    }

    public long getSlowestTaskExecuteTime() {
        return this.slowestTaskExecuteTime;
    }

    public void setSlowestTaskExecuteTime(long slowestTaskExecuteTime) {
        this.slowestTaskExecuteTime = slowestTaskExecuteTime;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getOutputRecords() {
        return this.outputRecords;
    }

    public void setOutputRecords(long outputRecords) {
        this.outputRecords = outputRecords;
    }

    public long getInputKb() {
        return this.inputKb;
    }

    public void setInputKb(long inputKb) {
        this.inputKb = inputKb;
    }

    public long getOutputKb() {
        return this.outputKb;
    }

    public void setOutputKb(long outputKb) {
        this.outputKb = outputKb;
    }

    public static CycleMetrics build(String metricName, String pipelineName, String opName, int taskNum, int slowestTask, long startTime, long duration, long totalExecuteTime, long totalGcTime, long slowestTaskExecuteTime, long totalInputRecords, long totalInputBytes, long totalOutputRecords, long totalOutputBytes) {
        CycleMetrics cycleMetrics = new CycleMetrics(metricName, pipelineName, opName);
        cycleMetrics.setStartTime(startTime);
        cycleMetrics.setTotalTasks(taskNum);
        cycleMetrics.setSlowestTask(slowestTask);
        cycleMetrics.setDuration(duration);
        cycleMetrics.setAvgExecuteTime(totalExecuteTime / (long)taskNum);
        cycleMetrics.setAvgGcTime(totalGcTime / (long)taskNum);
        cycleMetrics.setSlowestTaskExecuteTime(slowestTaskExecuteTime);
        cycleMetrics.setInputRecords(totalInputRecords);
        cycleMetrics.setInputKb(totalInputBytes / 1024L);
        cycleMetrics.setOutputRecords(totalOutputRecords);
        cycleMetrics.setOutputKb(totalOutputBytes / 1024L);
        return cycleMetrics;
    }

    public String toString() {
        return "CycleMetrics{pipelineName='" + this.pipelineName + '\'' + ", name='" + this.name + '\'' + ", opName='" + this.opName + '\'' + ", duration=" + this.duration + "ms, totalTasks=" + this.totalTasks + ", slowestTask=" + this.slowestTask + ", slowestTaskExecuteTime=" + this.slowestTaskExecuteTime + "ms, avgGcTime=" + this.avgGcTime + "ms, avgExecuteTime=" + this.avgExecuteTime + "ms, inputRecords=" + this.inputRecords + ", inputKb=" + this.inputKb + ", outputRecords=" + this.outputRecords + ", outputKb=" + this.outputKb + '}';
    }
}

