/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.metric;

import java.io.Serializable;

public class ShuffleReadMetrics
implements Serializable {
    private int fetchSlices;
    private long fetchRecords;
    private long decodeBytes;
    private long fetchWaitMs;
    private long decodeMs;
    private long requestMs;

    public void merge(ShuffleReadMetrics readMetrics) {
        if (readMetrics != null) {
            this.fetchSlices += readMetrics.getFetchSlices();
            this.fetchRecords += readMetrics.getFetchRecords();
            this.decodeBytes += readMetrics.getDecodeBytes();
            this.fetchWaitMs += readMetrics.getFetchWaitMs();
            this.decodeMs += readMetrics.getDecodeMs();
        }
    }

    public int getFetchSlices() {
        return this.fetchSlices;
    }

    public void setFetchSlices(int fetchSlices) {
        this.fetchSlices = fetchSlices;
    }

    public long getFetchRecords() {
        return this.fetchRecords;
    }

    public void setFetchRecords(long fetchRecords) {
        this.fetchRecords = fetchRecords;
    }

    public long getDecodeBytes() {
        return this.decodeBytes;
    }

    public void setDecodeBytes(long decodeBytes) {
        this.decodeBytes = decodeBytes;
    }

    public void increaseDecodeBytes(long decodeBytes) {
        this.decodeBytes += decodeBytes;
    }

    public long getFetchWaitMs() {
        return this.fetchWaitMs;
    }

    public void setFetchWaitMs(long fetchWaitMs) {
        this.fetchWaitMs = fetchWaitMs;
    }

    public long getDecodeMs() {
        return this.decodeMs;
    }

    public void setDecodeMs(long decodeMs) {
        this.decodeMs = decodeMs;
    }

    public long getRequestMs() {
        return this.requestMs;
    }

    public void setRequestMs(long requestMs) {
        this.requestMs = requestMs;
    }

    public void updateDecodeBytes(long decodeBytes) {
        this.decodeBytes += decodeBytes;
    }

    public void updateFetchRecords(long records) {
        this.fetchRecords += records;
    }

    public void increaseDecodeMs(long decodeMs) {
        this.decodeMs += decodeMs;
    }

    public void incFetchWaitMs(long fetchWaitMs) {
        this.fetchWaitMs += fetchWaitMs;
    }

    public String toString() {
        return "ReadMetrics{fetchSlices=" + this.fetchSlices + ", fetchRecords=" + this.fetchRecords + ", decodeKB=" + this.decodeBytes / 1024L + ", fetchWaitMs=" + this.fetchWaitMs + ", decodeMs=" + this.decodeMs + '}';
    }
}

