/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.metric;

import java.io.Serializable;

public class ShuffleWriteMetrics
implements Serializable {
    private long numChannels;
    private long writtenChannels;
    private long writtenRecords;
    private long encodedSize;
    private long encodeMs;
    private long maxSliceKB;
    private int spillNum;
    private int spillDisk;
    private int oomCount;
    private long maxSpillKB;
    private long spillMs;
    private long flushMs;

    public void merge(ShuffleWriteMetrics metrics) {
        this.numChannels += metrics.numChannels;
        this.writtenChannels += metrics.writtenChannels;
        this.writtenRecords += metrics.writtenRecords;
        this.encodedSize += metrics.encodedSize;
        this.encodeMs += metrics.encodeMs;
        this.spillNum += metrics.spillNum;
        this.spillDisk += metrics.spillDisk;
        this.oomCount += metrics.oomCount;
        this.spillMs += metrics.spillMs;
        this.flushMs += metrics.flushMs;
        this.maxSliceKB = Math.max(this.maxSliceKB, metrics.maxSliceKB);
        this.maxSpillKB = Math.max(this.maxSpillKB, metrics.maxSpillKB);
    }

    public long getWrittenRecords() {
        return this.writtenRecords;
    }

    public void setWrittenRecords(long writtenRecords) {
        this.writtenRecords = writtenRecords;
    }

    public long getEncodedSize() {
        return this.encodedSize;
    }

    public void setEncodedSize(long encodedSize) {
        this.encodedSize = encodedSize;
    }

    public long getEncodeMs() {
        return this.encodeMs;
    }

    public void setEncodeMs(long encodeMs) {
        this.encodeMs = encodeMs;
    }

    public int getSpillNum() {
        return this.spillNum;
    }

    public void setSpillNum(int spillNum) {
        this.spillNum = spillNum;
    }

    public int getSpillDisk() {
        return this.spillDisk;
    }

    public void setSpillDisk(int spillDisk) {
        this.spillDisk = spillDisk;
    }

    public int getOomCount() {
        return this.oomCount;
    }

    public void setOomCount(int oomCount) {
        this.oomCount = oomCount;
    }

    public long getMaxSpillKB() {
        return this.maxSpillKB;
    }

    public void setMaxSpillKB(long maxSpillKB) {
        this.maxSpillKB = maxSpillKB;
    }

    public long getMaxSliceKB() {
        return this.maxSliceKB;
    }

    public void setMaxSliceKB(long maxSliceSizeKB) {
        this.maxSliceKB = maxSliceSizeKB;
    }

    public long getSpillMs() {
        return this.spillMs;
    }

    public void setSpillMs(long spillMs) {
        this.spillMs = spillMs;
    }

    public long getNumChannels() {
        return this.numChannels;
    }

    public void setNumChannels(long numChannels) {
        this.numChannels = numChannels;
    }

    public long getWrittenChannels() {
        return this.writtenChannels;
    }

    public void setWrittenChannels(long writtenChannels) {
        this.writtenChannels = writtenChannels;
    }

    public long getFlushMs() {
        return this.flushMs;
    }

    public void setFlushMs(long flushMs) {
        this.flushMs = flushMs;
    }

    public void increaseRecords(long recordNum) {
        this.writtenRecords += recordNum;
    }

    public void increaseEncodedSize(long bytes) {
        this.encodedSize += bytes;
    }

    public void increaseEncodeMs(long encodeMs) {
        this.encodeMs += encodeMs;
    }

    public void increaseSpillMs(long spillMs) {
        this.spillMs += spillMs;
    }

    public void increaseSpillNum() {
        ++this.spillNum;
    }

    public void increaseWrittenChannels() {
        ++this.writtenChannels;
    }

    public void updateMaxSpillKB(long spillKB) {
        if (this.maxSpillKB < spillKB) {
            this.maxSpillKB = spillKB;
        }
    }

    public String toString() {
        return "WriteMetrics{outputRecords=" + this.writtenRecords + ", encodedKb=" + this.encodedSize / 1024L + ", encodeMs=" + this.encodeMs + ", spillNum=" + this.spillNum + ", spillDisk=" + this.spillDisk + ", oomCnt=" + this.oomCount + ", spillMs=" + this.spillMs + ", maxSpillKB=" + this.maxSpillKB + ", maxSliceKB=" + this.maxSliceKB + ", channels=" + this.numChannels + ", writtenChannels=" + this.writtenChannels + '}';
    }
}

