/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.rpc;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.baidu.brpc.client.RpcClientOptions;
import com.baidu.brpc.client.channel.ChannelType;
import com.baidu.brpc.protocol.Options;
import com.baidu.brpc.utils.BrpcConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableClientOption {
    private static final String SHORT_CONNECTION = "short_connection";
    private static final String SINGLE_CONNECTION = "single_connection";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableClientOption.class);

    public static RpcClientOptions build(Configuration config) {
        RpcClientOptions clientOption = new RpcClientOptions();
        clientOption.setProtocolType(1);
        int maxRetryTimes = config.getInteger(ExecutionConfigKeys.RPC_MAX_RETRY_TIMES);
        clientOption.setMaxTryTimes(maxRetryTimes);
        int maxTotalConnectionNum = config.getInteger(ExecutionConfigKeys.RPC_MAX_TOTAL_CONNECTION_NUM);
        clientOption.setMaxTotalConnections(maxTotalConnectionNum);
        int minIdleConnectionNum = config.getInteger(ExecutionConfigKeys.RPC_MIN_IDLE_CONNECTION_NUM);
        clientOption.setMinIdleConnections(minIdleConnectionNum);
        clientOption.setLoadBalanceType(1);
        clientOption.setCompressType(Options.CompressType.COMPRESS_TYPE_NONE);
        boolean threadSharing = config.getBoolean(ExecutionConfigKeys.RPC_THREADPOOL_SHARING_ENABLE);
        clientOption.setGlobalThreadPoolSharing(threadSharing);
        int ioThreadNum = config.getInteger(ExecutionConfigKeys.RPC_IO_THREAD_NUM);
        int workerThreadNum = config.getInteger(ExecutionConfigKeys.RPC_WORKER_THREAD_NUM);
        int defaultThreads = Runtime.getRuntime().availableProcessors();
        clientOption.setIoThreadNum(Math.max(ioThreadNum, defaultThreads));
        clientOption.setWorkThreadNum(Math.max(workerThreadNum, defaultThreads));
        clientOption.setIoEventType(BrpcConstants.IO_EVENT_NETTY_EPOLL);
        int rpcBufferSize = config.getInteger(ExecutionConfigKeys.RPC_BUFFER_SIZE_BYTES);
        clientOption.setSendBufferSize(rpcBufferSize);
        clientOption.setReceiveBufferSize(rpcBufferSize);
        ChannelType channelType = ConfigurableClientOption.getChannelType(config);
        if (ChannelType.SINGLE_CONNECTION.equals((Object)channelType)) {
            int keepAliveTime = config.getInteger(ExecutionConfigKeys.RPC_KEEP_ALIVE_TIME_SEC);
            clientOption.setKeepAliveTime(keepAliveTime);
        }
        clientOption.setChannelType(channelType);
        int writeTimeout = config.getInteger(ExecutionConfigKeys.RPC_WRITE_TIMEOUT_MS);
        clientOption.setWriteTimeoutMillis(writeTimeout);
        int readTimeout = config.getInteger(ExecutionConfigKeys.RPC_READ_TIMEOUT_MS);
        clientOption.setReadTimeoutMillis(readTimeout);
        int connectTimeout = config.getInteger(ExecutionConfigKeys.RPC_CONNECT_TIMEOUT_MS);
        clientOption.setConnectTimeoutMillis(connectTimeout);
        LOGGER.info("rpc client options set: {}", (Object)clientOption);
        return clientOption;
    }

    private static ChannelType getChannelType(Configuration config) {
        String channelType = config.getString(ExecutionConfigKeys.RPC_CHANNEL_CONNECT_TYPE);
        if (channelType.equalsIgnoreCase(SHORT_CONNECTION)) {
            return ChannelType.SHORT_CONNECTION;
        }
        if (channelType.equalsIgnoreCase(SINGLE_CONNECTION)) {
            return ChannelType.SINGLE_CONNECTION;
        }
        return ChannelType.POOLED_CONNECTION;
    }
}

