/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.rpc;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.baidu.brpc.server.RpcServerOptions;
import com.baidu.brpc.utils.BrpcConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableServerOption {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurableServerOption.class);

    public static RpcServerOptions build(Configuration config) {
        RpcServerOptions serverOptions = new RpcServerOptions();
        serverOptions.setProtocolType(Integer.valueOf(1));
        int maxRetryTimes = config.getInteger(ExecutionConfigKeys.RPC_MAX_RETRY_TIMES);
        serverOptions.setMaxTryTimes(maxRetryTimes);
        int keepAliveTime = config.getInteger(ExecutionConfigKeys.RPC_KEEP_ALIVE_TIME_SEC);
        serverOptions.setKeepAliveTime(keepAliveTime);
        boolean threadSharing = config.getBoolean(ExecutionConfigKeys.RPC_THREADPOOL_SHARING_ENABLE);
        serverOptions.setGlobalThreadPoolSharing(threadSharing);
        int ioThreadNum = config.getInteger(ExecutionConfigKeys.RPC_IO_THREAD_NUM);
        int workerThreadNum = config.getInteger(ExecutionConfigKeys.RPC_WORKER_THREAD_NUM);
        int defaultThreads = Math.max(Runtime.getRuntime().availableProcessors(), 8);
        serverOptions.setIoThreadNum(Math.max(ioThreadNum, defaultThreads));
        serverOptions.setWorkThreadNum(Math.max(workerThreadNum, defaultThreads));
        serverOptions.setIoEventType(BrpcConstants.IO_EVENT_NETTY_EPOLL);
        int rpcBufferSize = config.getInteger(ExecutionConfigKeys.RPC_BUFFER_SIZE_BYTES);
        serverOptions.setSendBufferSize(rpcBufferSize);
        serverOptions.setReceiveBufferSize(rpcBufferSize);
        LOGGER.info("server options set: {}", (Object)serverOptions);
        return serverOptions;
    }
}

