/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.rpc;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public class HostAndPort
implements Serializable {
    private static final String DELIMITER = "_";
    private final String host;
    private final int port;

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public static HostAndPort of(String hostAndPort) {
        String[] strs = hostAndPort.split(DELIMITER);
        Preconditions.checkState((strs.length == 2 ? 1 : 0) != 0);
        return new HostAndPort(strs[0], Integer.parseInt(strs[1]));
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public String toString() {
        return this.host + DELIMITER + this.port;
    }
}

