/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.schema;

import com.antgroup.geaflow.common.schema.Field;
import com.antgroup.geaflow.common.schema.ISchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaImpl
implements ISchema {
    private final int id;
    private final String name;
    private final List<Field> fields;
    private final Map<String, Field> fieldMap;

    public SchemaImpl(String name, List<Field> fields) {
        this(0, name, fields);
    }

    public SchemaImpl(int id, String name, List<Field> fields) {
        this.id = id;
        this.name = name;
        this.fields = Collections.unmodifiableList(fields);
        this.fieldMap = Collections.unmodifiableMap(SchemaImpl.generateFieldMap(fields));
    }

    private static Map<String, Field> generateFieldMap(List<Field> fields) {
        HashMap<String, Field> map = new HashMap<String, Field>(fields.size());
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    @Override
    public int getSchemaId() {
        return this.id;
    }

    @Override
    public String getSchemaName() {
        return this.name;
    }

    @Override
    public Field getField(int index) {
        return this.fields.get(index);
    }

    @Override
    public Field getField(String fieldName) {
        return this.fieldMap.get(fieldName);
    }

    @Override
    public List<Field> getFields() {
        return this.fields;
    }
}

