/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.serialize.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Field;
import java.util.List;

public class SubListSerializers4Jdk9 {
    private static final Object FAKE_REFERENCE = new Object();

    static Class<?> getClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Class<?> getClassOrNull(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Serializer<List<?>> createFor(Class type) {
        if (ArrayListSubListSerializer.canSerialize(type)) {
            return new ArrayListSubListSerializer();
        }
        if (JavaUtilSubListSerializer.canSerialize(type)) {
            return new JavaUtilSubListSerializer();
        }
        return null;
    }

    public static Kryo addDefaultSerializers(Kryo kryo) {
        ArrayListSubListSerializer.addDefaultSerializer(kryo);
        AbstractListSubListSerializer.addDefaultSerializer(kryo);
        JavaUtilSubListSerializer.addDefaultSerializer(kryo);
        return kryo;
    }

    public static class JavaUtilSubListSerializer
    extends Serializer<List<?>> {
        public static final Class<?> SUBLIST_CLASS = SubListSerializers4Jdk9.getClassOrNull("java.util.SubList");
        private Field listField;
        private Field offsetField;
        private Field sizeField;

        public JavaUtilSubListSerializer() {
            try {
                Class<?> clazz = Class.forName("java.util.SubList");
                this.listField = clazz.getDeclaredField("l");
                this.offsetField = clazz.getDeclaredField("offset");
                this.sizeField = clazz.getDeclaredField("size");
                this.listField.setAccessible(true);
                this.offsetField.setAccessible(true);
                this.sizeField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static boolean canSerialize(Class<?> type) {
            return SUBLIST_CLASS != null && SUBLIST_CLASS.isAssignableFrom(type);
        }

        public static Kryo addDefaultSerializer(Kryo kryo) {
            if (SUBLIST_CLASS != null) {
                kryo.addDefaultSerializer(SUBLIST_CLASS, (Serializer)new JavaUtilSubListSerializer());
            }
            return kryo;
        }

        public List<?> read(Kryo kryo, Input input, Class<List<?>> clazz) {
            kryo.reference(FAKE_REFERENCE);
            List list = (List)kryo.readClassAndObject(input);
            int fromIndex = input.readInt(true);
            int toIndex = input.readInt(true);
            return list.subList(fromIndex, toIndex);
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            try {
                kryo.writeClassAndObject(output, this.listField.get(obj));
                int fromIndex = this.offsetField.getInt(obj);
                output.writeInt(fromIndex, true);
                int toIndex = fromIndex + this.sizeField.getInt(obj);
                output.writeInt(toIndex, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<?> copy(Kryo kryo, List<?> obj) {
            kryo.reference(FAKE_REFERENCE);
            try {
                List list = (List)this.listField.get(obj);
                int fromIndex = this.offsetField.getInt(obj);
                int toIndex = fromIndex + this.sizeField.getInt(obj);
                return ((List)kryo.copy((Object)list)).subList(fromIndex, toIndex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class AbstractListSubListSerializer
    extends Serializer<List<?>> {
        public static final Class<?> SUBLIST_CLASS = SubListSerializers4Jdk9.getClassOrNull("java.util.AbstractList$SubList");
        private final SubListSerializer delegate = new SubListSerializer("java.util.AbstractList$SubList");

        public static boolean canSerialize(Class<?> type) {
            return SUBLIST_CLASS != null && SUBLIST_CLASS.isAssignableFrom(type);
        }

        public static Kryo addDefaultSerializer(Kryo kryo) {
            if (SUBLIST_CLASS != null) {
                kryo.addDefaultSerializer(SUBLIST_CLASS, (Serializer)new AbstractListSubListSerializer());
            }
            return kryo;
        }

        public List<?> read(Kryo kryo, Input input, Class<List<?>> clazz) {
            return this.delegate.read(kryo, input, (Class)clazz);
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            this.delegate.write(kryo, output, obj);
        }

        public List<?> copy(Kryo kryo, List<?> original) {
            return this.delegate.copy(kryo, original);
        }
    }

    public static class ArrayListSubListSerializer
    extends Serializer<List<?>> {
        public static final Class<?> SUBLIST_CLASS = SubListSerializers4Jdk9.getClassOrNull("java.util.ArrayList$SubList");
        private final SubListSerializer delegate = new SubListSerializer("java.util.ArrayList$SubList");

        public static boolean canSerialize(Class<?> type) {
            return SUBLIST_CLASS != null && SUBLIST_CLASS.isAssignableFrom(type);
        }

        public static Kryo addDefaultSerializer(Kryo kryo) {
            if (SUBLIST_CLASS != null) {
                kryo.addDefaultSerializer(SUBLIST_CLASS, (Serializer)new ArrayListSubListSerializer());
            }
            return kryo;
        }

        public List<?> read(Kryo kryo, Input input, Class<List<?>> clazz) {
            return this.delegate.read(kryo, input, (Class)clazz);
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            this.delegate.write(kryo, output, obj);
        }

        public List<?> copy(Kryo kryo, List<?> original) {
            return this.delegate.copy(kryo, original);
        }
    }

    private static class SubListSerializer
    extends Serializer<List<?>> {
        private Field parentField;
        private Field parentOffsetField;
        private Field sizeField;

        public SubListSerializer(String subListClassName) {
            try {
                Class<?> clazz = Class.forName(subListClassName);
                this.parentField = SubListSerializer.getParentField(clazz);
                this.parentOffsetField = SubListSerializer.getOffsetField(clazz);
                this.sizeField = clazz.getDeclaredField("size");
                this.parentField.setAccessible(true);
                this.parentOffsetField.setAccessible(true);
                this.sizeField.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private static Field getParentField(Class clazz) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField("root");
            }
            catch (NoSuchFieldException e) {
                return clazz.getDeclaredField("parent");
            }
        }

        private static Field getOffsetField(Class<?> clazz) throws NoSuchFieldException {
            try {
                return clazz.getDeclaredField("parentOffset");
            }
            catch (NoSuchFieldException e) {
                return clazz.getDeclaredField("offset");
            }
        }

        public List<?> read(Kryo kryo, Input input, Class<List<?>> clazz) {
            kryo.reference(FAKE_REFERENCE);
            List list = (List)kryo.readClassAndObject(input);
            int fromIndex = input.readInt(true);
            int toIndex = input.readInt(true);
            return list.subList(fromIndex, toIndex);
        }

        public void write(Kryo kryo, Output output, List<?> obj) {
            try {
                int parentOffset;
                kryo.writeClassAndObject(output, this.parentField.get(obj));
                int fromIndex = parentOffset = this.parentOffsetField.getInt(obj);
                output.writeInt(fromIndex, true);
                int toIndex = fromIndex + this.sizeField.getInt(obj);
                output.writeInt(toIndex, true);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<?> copy(Kryo kryo, List<?> original) {
            kryo.reference(FAKE_REFERENCE);
            try {
                int parentOffset;
                List list = (List)this.parentField.get(original);
                int fromIndex = parentOffset = this.parentOffsetField.getInt(original);
                int toIndex = fromIndex + this.sizeField.getInt(original);
                return ((List)kryo.copy((Object)list)).subList(fromIndex, toIndex);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

