/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.thread;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoundedExecutor
extends ThreadPoolExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundedExecutor.class);
    private static final int DEFAULT_KEEP_ALIVE_MINUTES = 30;
    private final Semaphore semaphore;
    private final int counter;

    public BoundedExecutor(int bound, int capacity) {
        this(bound, capacity, 30L, TimeUnit.MINUTES);
    }

    public BoundedExecutor(int bound, int capacity, long keepAliveTime, TimeUnit unit) {
        super(bound, bound, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(capacity));
        this.counter = capacity + bound;
        this.semaphore = new Semaphore(this.counter);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        this.semaphore.release();
    }

    public void tryExecute(Runnable command) {
        while (true) {
            try {
                this.semaphore.acquire();
                super.execute(command);
            }
            catch (RejectedExecutionException e) {
                LOGGER.info("reject task, retry to submit");
                this.semaphore.release();
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new GeaflowRuntimeException(e);
            }
            break;
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            this.semaphore.acquire();
            return super.submit(task);
        }
        catch (RejectedExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.semaphore.release();
            throw e;
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new GeaflowRuntimeException(e);
        }
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        while (true) {
            try {
                this.semaphore.acquire();
                return super.submit(task);
            }
            catch (RejectedExecutionException e) {
                LOGGER.info("reject task, retry to submit");
                this.semaphore.release();
                continue;
            }
            catch (InterruptedException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new GeaflowRuntimeException(e);
            }
            break;
        }
    }

    public boolean isEmpty() {
        LOGGER.info("current available:{}, counter:{}", (Object)this.semaphore.availablePermits(), (Object)this.counter);
        return this.semaphore.availablePermits() == this.counter;
    }
}

