/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.thread;

import com.antgroup.geaflow.common.thread.BoundedExecutor;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class Executors {
    private static final int DEFAULT_KEEP_ALIVE_MINUTES = 30;
    private static final int DEFAULT_QUEUE_CAPACITY = 1024;
    private static final int DEFAULT_MAGNIFICATION = 2;
    private static final Map<String, ExecutorService> BOUNDED_EXECUTORS = new HashMap<String, ExecutorService>();
    private static final Map<String, ExecutorService> UNBOUNDED_EXECUTORS = new HashMap<String, ExecutorService>();
    private static final int CORE_NUM = Runtime.getRuntime().availableProcessors();

    private static String getKey(String type, int bound, int capacity, long keepAliveTime, TimeUnit unit) {
        return String.format("%s%s%s%s%s", new Object[]{type, bound, capacity, keepAliveTime, unit});
    }

    public static synchronized ExecutorService getBoundedService(int bound, int capacity, long keepAliveTime, TimeUnit unit) {
        String key = Executors.getKey("bound", bound, capacity, keepAliveTime, unit);
        if (BOUNDED_EXECUTORS.get(key) == null) {
            BoundedExecutor boundedExecutor = new BoundedExecutor(bound, capacity, keepAliveTime, unit);
            BOUNDED_EXECUTORS.put(key, boundedExecutor);
        }
        return BOUNDED_EXECUTORS.get(key);
    }

    public static synchronized ExecutorService getMaxCoreBoundedService() {
        return Executors.getMaxCoreBoundedService(2);
    }

    public static synchronized ExecutorService getMaxCoreBoundedService(int magnification) {
        int cores = Runtime.getRuntime().availableProcessors();
        return Executors.getBoundedService(magnification * cores, 1024, 30L, TimeUnit.MINUTES);
    }

    public static synchronized ExecutorService getService(int bound, int capacity, long keepAliveTime, TimeUnit unit) {
        String key = Executors.getKey("normal", bound, capacity, keepAliveTime, unit);
        if (BOUNDED_EXECUTORS.get(key) == null) {
            ThreadPoolExecutor boundedExecutor = new ThreadPoolExecutor(bound, bound, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(capacity));
            BOUNDED_EXECUTORS.put(key, boundedExecutor);
        }
        return BOUNDED_EXECUTORS.get(key);
    }

    public static synchronized ExecutorService getMultiCoreExecutorService(int maxMultiple, double magnification) {
        return Executors.getExecutorService(maxMultiple, (int)(magnification * (double)CORE_NUM));
    }

    public static synchronized ExecutorService getExecutorService(int maxMultiple, int coreNumber) {
        Preconditions.checkArgument((coreNumber > 0 && coreNumber <= maxMultiple * CORE_NUM ? 1 : 0) != 0, (Object)("executor core not right " + coreNumber + " is greater than " + maxMultiple * CORE_NUM));
        return Executors.getService(coreNumber, Integer.MAX_VALUE, 30L, TimeUnit.MINUTES);
    }

    public static synchronized ExecutorService getExecutorService(int coreNumber, String threadFormat) {
        int maxThreads = 10 * CORE_NUM;
        Preconditions.checkArgument((coreNumber > 0 && coreNumber <= maxThreads ? 1 : 0) != 0, (Object)("executor threads should be smaller than " + maxThreads));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)threadFormat), (Object)"thread format couldn't be empty");
        return Executors.getNamedService(coreNumber, Integer.MAX_VALUE, 30L, TimeUnit.MINUTES, threadFormat, null);
    }

    public static synchronized ExecutorService getExecutorService(int coreNumber, String threadFormat, Thread.UncaughtExceptionHandler handler) {
        int maxThreads = 10 * CORE_NUM;
        Preconditions.checkArgument((coreNumber > 0 && coreNumber <= maxThreads ? 1 : 0) != 0, (Object)("executor threads should be smaller than " + maxThreads));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)threadFormat), (Object)"thread format couldn't be empty");
        return Executors.getNamedService(coreNumber, Integer.MAX_VALUE, 30L, TimeUnit.MINUTES, threadFormat, handler);
    }

    public static synchronized ExecutorService getExecutorService(int maxMultiple, int coreNumber, String threadFormat) {
        int maxThreads = maxMultiple * CORE_NUM;
        Preconditions.checkArgument((coreNumber > 0 && coreNumber <= maxThreads ? 1 : 0) != 0, (Object)("executor threads should be smaller than " + maxThreads));
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)threadFormat), (Object)"thread format couldn't be empty");
        return Executors.getNamedService(coreNumber, Integer.MAX_VALUE, 30L, TimeUnit.MINUTES, threadFormat, null);
    }

    private static synchronized ExecutorService getNamedService(int bound, int capacity, long keepAliveTime, TimeUnit unit, String threadFormat, Thread.UncaughtExceptionHandler handler) {
        String key = Executors.getKey(threadFormat, bound, capacity, keepAliveTime, unit);
        if (BOUNDED_EXECUTORS.get(key) == null || BOUNDED_EXECUTORS.get(key).isShutdown()) {
            ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setNameFormat(threadFormat).setDaemon(true);
            if (handler != null) {
                builder.setUncaughtExceptionHandler(handler);
            }
            ThreadPoolExecutor boundedExecutor = new ThreadPoolExecutor(bound, bound, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(capacity), builder.build());
            BOUNDED_EXECUTORS.put(key, boundedExecutor);
        }
        return BOUNDED_EXECUTORS.get(key);
    }

    public static synchronized ExecutorService getUnboundedExecutorService(String name, long keepAliveTime, TimeUnit unit, String threadFormat, Thread.UncaughtExceptionHandler handler) {
        ExecutorService cached = UNBOUNDED_EXECUTORS.get(name);
        if (cached != null && !cached.isShutdown()) {
            return cached;
        }
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder().setDaemon(true);
        if (threadFormat != null) {
            builder.setNameFormat(threadFormat);
        }
        if (handler != null) {
            builder.setUncaughtExceptionHandler(handler);
        }
        ThreadPoolExecutor pool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, keepAliveTime, unit, new SynchronousQueue<Runnable>(), builder.build());
        UNBOUNDED_EXECUTORS.put(name, pool);
        return pool;
    }
}

