/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.type;

import com.antgroup.geaflow.common.binary.BinaryString;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.primitive.BinaryStringType;
import com.antgroup.geaflow.common.type.primitive.BooleanType;
import com.antgroup.geaflow.common.type.primitive.ByteType;
import com.antgroup.geaflow.common.type.primitive.DateType;
import com.antgroup.geaflow.common.type.primitive.DecimalType;
import com.antgroup.geaflow.common.type.primitive.DoubleType;
import com.antgroup.geaflow.common.type.primitive.FloatType;
import com.antgroup.geaflow.common.type.primitive.IntegerType;
import com.antgroup.geaflow.common.type.primitive.LongType;
import com.antgroup.geaflow.common.type.primitive.ShortType;
import com.antgroup.geaflow.common.type.primitive.StringType;
import com.antgroup.geaflow.common.type.primitive.TimestampType;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Locale;

public class Types {
    public static final String TYPE_NAME_BOOLEAN = "BOOLEAN";
    public static final String TYPE_NAME_BYTE = "BYTE";
    public static final String TYPE_NAME_SHORT = "SHORT";
    public static final String TYPE_NAME_INTEGER = "INTEGER";
    public static final String TYPE_NAME_LONG = "LONG";
    public static final String TYPE_NAME_FLOAT = "FLOAT";
    public static final String TYPE_NAME_DOUBLE = "DOUBLE";
    public static final String TYPE_NAME_STRING = "STRING";
    public static final String TYPE_NAME_STRUCT = "STRUCT";
    public static final String TYPE_NAME_ARRAY = "ARRAY";
    public static final String TYPE_NAME_VERTEX = "VERTEX";
    public static final String TYPE_NAME_EDGE = "EDGE";
    public static final String TYPE_NAME_PATH = "PATH";
    public static final String TYPE_NAME_CLASS = "CLASS";
    public static final String TYPE_NAME_DECIMAL = "DECIMAL";
    public static final String TYPE_NAME_GRAPH = "GRAPH";
    public static final String TYPE_NAME_OBJECT = "OBJECT";
    public static final String TYPE_NAME_BINARY_STRING = "BINARY_STRING";
    public static final String TYPE_NAME_TIMESTAMP = "TIMESTAMP";
    public static final String TYPE_NAME_DATE = "DATE";
    public static final IType<Boolean> BOOLEAN = BooleanType.INSTANCE;
    public static final IType<Byte> BYTE = ByteType.INSTANCE;
    public static final IType<Short> SHORT = ShortType.INSTANCE;
    public static final IType<Integer> INTEGER = IntegerType.INSTANCE;
    public static final IType<Long> LONG = LongType.INSTANCE;
    public static final IType<Float> FLOAT = FloatType.INSTANCE;
    public static final IType<Double> DOUBLE = DoubleType.INSTANCE;
    public static final IType<String> STRING = StringType.INSTANCE;
    public static final IType<BigDecimal> DECIMAL = DecimalType.INSTANCE;
    public static final IType<BinaryString> BINARY_STRING = BinaryStringType.INSTANCE;
    public static final IType<Timestamp> TIMESTAMP = TimestampType.INSTANCE;
    public static final IType<Date> DATE = DateType.INSTANCE;
    public static final ImmutableMap<Class, IType> TYPE_IMMUTABLE_MAP = ImmutableMap.builder().put(BOOLEAN.getTypeClass(), BOOLEAN).put(BYTE.getTypeClass(), BYTE).put(SHORT.getTypeClass(), SHORT).put(INTEGER.getTypeClass(), INTEGER).put(LONG.getTypeClass(), LONG).put(FLOAT.getTypeClass(), FLOAT).put(DOUBLE.getTypeClass(), DOUBLE).put(STRING.getTypeClass(), STRING).put(DECIMAL.getTypeClass(), DECIMAL).put(BINARY_STRING.getTypeClass(), BINARY_STRING).put(TIMESTAMP.getTypeClass(), TIMESTAMP).put(DATE.getTypeClass(), DATE).build();

    public static <T> IType<T> getType(Class<T> type) {
        return (IType)TYPE_IMMUTABLE_MAP.get(type);
    }

    public static IType<?> of(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("typeName is null");
        }
        switch (typeName.toUpperCase(Locale.ROOT)) {
            case "BOOLEAN": {
                return BOOLEAN;
            }
            case "BYTE": {
                return BYTE;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "INTEGER": {
                return INTEGER;
            }
            case "LONG": {
                return LONG;
            }
            case "STRING": {
                return STRING;
            }
            case "DECIMAL": {
                return DECIMAL;
            }
            case "BINARY_STRING": {
                return BINARY_STRING;
            }
            case "TIMESTAMP": {
                return TIMESTAMP;
            }
            case "DATE": {
                return DATE;
            }
        }
        throw new IllegalArgumentException("Not support typeName: " + typeName);
    }

    public static int compare(Comparable a, Comparable b) {
        if (null == a) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }
}

