/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.type.primitive;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;

public class BooleanType
implements IType<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    @Override
    public String getName() {
        return "BOOLEAN";
    }

    @Override
    public Class<Boolean> getTypeClass() {
        return Boolean.class;
    }

    @Override
    public byte[] serialize(Boolean obj) {
        if (obj == null) {
            return null;
        }
        if (Boolean.TRUE.equals(obj)) {
            return new byte[]{1};
        }
        if (Boolean.FALSE.equals(obj)) {
            return new byte[]{0};
        }
        String msg = "illegal boolean value: " + obj;
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
    }

    @Override
    public Boolean deserialize(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (bytes[0] == 1) {
            return Boolean.TRUE;
        }
        if (bytes[0] == 0) {
            return Boolean.FALSE;
        }
        String msg = "illegal boolean value: " + bytes[0];
        throw new GeaflowRuntimeException(RuntimeErrors.INST.typeSysError(msg));
    }

    @Override
    public int compare(Boolean a, Boolean b) {
        return Types.compare(a, b);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

