/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.type.primitive;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.google.common.primitives.Longs;

public class DoubleType
implements IType<Double> {
    public static final DoubleType INSTANCE = new DoubleType();

    @Override
    public String getName() {
        return "DOUBLE";
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    @Override
    public byte[] serialize(Double obj) {
        return Longs.toByteArray((long)Double.doubleToLongBits(obj));
    }

    @Override
    public Double deserialize(byte[] bytes) {
        return Double.longBitsToDouble(Longs.fromByteArray((byte[])bytes));
    }

    @Override
    public int compare(Double a, Double b) {
        return Types.compare(a, b);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

