/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.type.primitive;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.google.common.primitives.Ints;

public class FloatType
implements IType<Float> {
    public static final FloatType INSTANCE = new FloatType();

    @Override
    public String getName() {
        return "FLOAT";
    }

    @Override
    public Class<Float> getTypeClass() {
        return Float.class;
    }

    @Override
    public byte[] serialize(Float obj) {
        return Ints.toByteArray((int)Float.floatToIntBits(obj.floatValue()));
    }

    @Override
    public Float deserialize(byte[] bytes) {
        return Float.valueOf(Float.intBitsToFloat(Ints.fromByteArray((byte[])bytes)));
    }

    @Override
    public int compare(Float a, Float b) {
        return Types.compare(a, b);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

