/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.type.primitive;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.google.common.primitives.Ints;

public class IntegerType
implements IType<Integer> {
    public static final IntegerType INSTANCE = new IntegerType();

    @Override
    public String getName() {
        return "INTEGER";
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public byte[] serialize(Integer obj) {
        return Ints.toByteArray((int)obj);
    }

    @Override
    public Integer deserialize(byte[] bytes) {
        return Ints.fromByteArray((byte[])bytes);
    }

    @Override
    public int compare(Integer a, Integer b) {
        return Types.compare(a, b);
    }

    @Override
    public boolean isPrimitive() {
        return true;
    }

    public String toString() {
        return this.getName();
    }
}

