/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;

public class ClassUtil {
    public static <O> Class<O> classForName(String className) {
        return ClassUtil.classForName(className, true);
    }

    public static <O> Class<O> classForName(String className, boolean initialize) {
        try {
            return Class.forName(className, initialize, ClassUtil.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new GeaflowRuntimeException(e);
        }
    }

    public static <O> Class<O> classForName(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new GeaflowRuntimeException("fail to load class:" + className, e);
        }
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassUtil.class.getClassLoader();
        }
        return classLoader;
    }

    public static <O> O newInstance(Class<O> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new GeaflowRuntimeException("fail to create instance for: " + clazz, e);
        }
    }

    public static <O> O newInstance(String className) {
        Class<O> clazz = ClassUtil.classForName(className, Thread.currentThread().getContextClassLoader());
        return ClassUtil.newInstance(clazz);
    }
}

