/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.utils.SleepUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorUtil.class);
    private static final int SHUTDOWN_TIMEOUT_MS = 1000;

    public static void execute(ExecutorService service, Runnable command, ExceptionHandler handler) {
        service.execute(() -> {
            try {
                command.run();
            }
            catch (Throwable throwable) {
                handler.handle(throwable);
            }
        });
    }

    public static void spinLockMs(Supplier<Boolean> condition, Runnable checkFun, long ms) {
        while (!condition.get().booleanValue()) {
            SleepUtils.sleepMilliSecond(ms);
            checkFun.run();
        }
    }

    public static void shutdown(ExecutorService executorService, long timeout, TimeUnit timeUnit) {
        LOGGER.info("shutdown executor service {}", (Object)executorService);
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(timeout, timeUnit)) {
                LOGGER.info("shutdown executor service force");
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted when shutdown executor service", (Throwable)e);
        }
    }

    public static void shutdown(ExecutorService executorService) {
        ExecutorUtil.shutdown(executorService, 1000L, TimeUnit.MILLISECONDS);
    }

    public static interface ExceptionHandler {
        public void handle(Throwable var1);
    }
}

