/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class FileUtil {
    public static String concatPath(String baseDir, String fileName) {
        if (baseDir == null || fileName == null) {
            throw new NullPointerException();
        }
        if (baseDir.endsWith("/")) {
            return baseDir + fileName;
        }
        return baseDir + "/" + fileName;
    }

    public static String constitutePath(String ... args) {
        return File.separator + Joiner.on((String)File.separator).join((Object[])args);
    }

    public static String getContentFromFile(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            StringBuilder content = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line).append(System.lineSeparator());
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error read file content.", e);
            }
            return content.toString();
        }
        return null;
    }
}

