/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class FutureUtil {
    public static <T> List<T> wait(List<Future<T>> futureList) {
        return FutureUtil.wait(futureList, 0);
    }

    public static <T> List<T> wait(List<Future<T>> futureList, int timeoutMs) {
        return FutureUtil.wait(futureList, timeoutMs, TimeUnit.MILLISECONDS);
    }

    public static <T> List<T> wait(Collection<Future<T>> futureList, long timeout, TimeUnit timeUnit) {
        ArrayList<T> result = new ArrayList<T>();
        for (Future<T> future : futureList) {
            try {
                if (timeout > 0L) {
                    result.add(future.get(timeout, timeUnit));
                    continue;
                }
                result.add(future.get());
            }
            catch (Exception e) {
                throw new GeaflowRuntimeException(e);
            }
        }
        return result;
    }
}

