/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

public class IdGenerator {
    private static final long START_EPOCH = 1611158400000L;
    private final long sequenceBits = 6L;
    private final int containerIdBits = 16;
    private final long maxContainerId = 65535L;
    private final long containerIdShift = 6L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 63L;
    private long containerId;
    private long lastTimestamp = -1L;
    private long sequence = 0L;

    public IdGenerator(long containerId) {
        if (containerId > 65535L || containerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 65535L));
        }
        this.containerId = containerId;
    }

    public synchronized long nextId() {
        long timestamp = this.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1611158400000L << 22 | this.containerId << 6 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = this.currentTimeMillis();
        }
        return timestamp;
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }
}

