/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import org.slf4j.Logger;

public class LoggerFormatter {
    public static String getCycleName(int cycleId) {
        return String.format("cycle#%s", cycleId);
    }

    public static String getCycleName(int cycleId, long windowId) {
        return String.format("cycle#%s-%s", cycleId, windowId);
    }

    public static String getCycleTag(String pipelineName, int cycleId) {
        return String.format("%s %s", pipelineName, LoggerFormatter.getCycleName(cycleId));
    }

    public static String getCycleTag(String pipelineName, int cycleId, long windowId) {
        return String.format("%s %s", pipelineName, LoggerFormatter.getCycleName(cycleId, windowId));
    }

    public static String getCycleMetricName(int cycleId, int vertexId) {
        return String.format("%s[%d]", LoggerFormatter.getCycleName(cycleId), vertexId);
    }

    public static String getCycleMetricName(int cycleId, long windowId, int vertexId) {
        return String.format("%s[%d]", LoggerFormatter.getCycleName(cycleId, windowId), vertexId);
    }

    public static String getTaskTag(String pipelineName, int cycleId, int taskId, int vertexId, int index, int parallelism) {
        return String.format("%s task#%d [%d-%d/%d]", LoggerFormatter.getCycleTag(pipelineName, cycleId), taskId, vertexId, index, parallelism);
    }

    public static String getTaskTag(String pipelineName, int cycleId, long windowId, int taskId, int vertexId, int index, int parallelism) {
        return String.format("%s task#%d [%d-%d/%d]", LoggerFormatter.getCycleTag(pipelineName, cycleId, windowId), taskId, vertexId, index, parallelism);
    }

    public static String getStackMsg(Exception e) {
        StringBuffer sb = new StringBuffer();
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        return sb.toString();
    }

    public static void debug(Logger logger, String msg) {
        if (logger.isDebugEnabled()) {
            logger.debug(msg);
        }
    }

    public static void debug(Logger logger, String msg, Object o) {
        if (logger.isDebugEnabled()) {
            logger.debug(msg, o);
        }
    }

    public static void debug(Logger logger, String msg, Object ... o) {
        if (logger.isDebugEnabled()) {
            logger.debug(msg, o);
        }
    }

    public static void info(Logger logger, String msg) {
        if (logger.isInfoEnabled()) {
            logger.info(msg);
        }
    }

    public static void info(Logger logger, String msg, Object o) {
        if (logger.isInfoEnabled()) {
            logger.info(msg, o);
        }
    }

    public static void info(Logger logger, String msg, Object ... o) {
        if (logger.isInfoEnabled()) {
            logger.info(msg, o);
        }
    }

    public static void info(Logger logger, String msg, Throwable t) {
        if (logger.isInfoEnabled()) {
            logger.info(msg, t);
        }
    }

    public static void warn(Logger logger, String msg) {
        logger.warn(msg);
    }

    public static void warn(Logger logger, String msg, Object ... o) {
        logger.warn(msg, o);
    }

    public static void warn(Logger logger, String msg, Throwable t) {
        logger.warn(msg, t);
    }

    public static void error(Logger logger, String msg) {
        logger.error(msg);
    }

    public static void error(Logger logger, String msg, Object ... o) {
        logger.error(msg, o);
    }

    public static void error(Logger logger, String msg, Throwable t) {
        logger.error(msg, t);
    }
}

