/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.common.utils.SystemArgsUtil;
import com.google.common.base.Preconditions;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

public final class ReflectionUtil {
    public static final int JAVA_VERSION = ReflectionUtil.majorVersion(SystemArgsUtil.get("java.specification.version", "1.6"));

    private static int majorVersion(String javaSpecVersion) {
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            Preconditions.checkArgument((version[1] >= 6 ? 1 : 0) != 0);
            return version[1];
        }
        return version[0];
    }

    private ReflectionUtil() {
    }

    public static Throwable trySetAccessible(AccessibleObject object, boolean checkAccessible) {
        if (checkAccessible && JAVA_VERSION >= 9) {
            return new UnsupportedOperationException("Reflective setAccessible(true) disabled");
        }
        try {
            object.setAccessible(true);
            return null;
        }
        catch (Exception e) {
            return new GeaflowRuntimeException(e);
        }
    }

    public static Object getField(Object object, String fieldName) {
        try {
            Field field = ReflectionUtil.getField(object.getClass(), fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(e);
        }
    }

    private static Field getField(Class clazz, String fieldName) throws NoSuchFieldException {
        while (clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchFieldException(fieldName);
    }

    public static void setField(Object instance, String fieldName, Object value) throws Exception {
        Field field = ReflectionUtil.getField(instance.getClass(), fieldName);
        field.setAccessible(true);
        field.set(instance, value);
    }
}

