/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.Random;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryCommand.class);
    private static final Random RANDOM = new Random();

    public static <T> T run(Callable<T> function, int retryCount) {
        return RetryCommand.run(function, retryCount, 0L);
    }

    public static <T> T run(Callable<T> function, int retryCount, long retryIntervalMs) {
        return RetryCommand.run(function, null, retryCount, retryIntervalMs);
    }

    public static <T> T run(Callable<T> function, Callable retryFunction, int retryCount, long retryIntervalMs) {
        return RetryCommand.run(function, retryFunction, retryCount, retryIntervalMs, false);
    }

    public static <T> T run(Callable<T> function, Callable retryFunction, int retryCount, long retryIntervalMs, boolean needRandom) {
        int i = retryCount;
        while (0 < i) {
            try {
                return function.call();
            }
            catch (Exception e) {
                if (--i == 0) {
                    LOGGER.error("Retry failed and reached the maximum retried times.", (Throwable)e);
                    throw new GeaflowRuntimeException(e);
                }
                try {
                    long sleepTime = needRandom ? retryIntervalMs * (long)(RANDOM.nextInt(retryCount) + 1) : retryIntervalMs;
                    LOGGER.warn("Retry failed, will retry {} times with interval {} ms", (Object)i, (Object)sleepTime);
                    Thread.sleep(sleepTime);
                    if (retryFunction == null) continue;
                    retryFunction.call();
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return null;
    }
}

