/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SleepUtils.class);

    public static void sleepSecond(long second) {
        try {
            TimeUnit.SECONDS.sleep(second);
        }
        catch (InterruptedException e) {
            LOGGER.warn("sleep {}s interrupted", (Object)second);
            throw new GeaflowRuntimeException(e);
        }
    }

    public static void sleepMilliSecond(long mileSecond) {
        try {
            TimeUnit.MILLISECONDS.sleep(mileSecond);
        }
        catch (InterruptedException e) {
            LOGGER.warn("sleepMilliSecond {}ms interrupted", (Object)mileSecond);
            throw new GeaflowRuntimeException(e);
        }
    }
}

