/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.common.utils;

import java.security.AccessController;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemArgsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemArgsUtil.class);

    private SystemArgsUtil() {
    }

    public static String get(String key) {
        return SystemArgsUtil.get(key, null);
    }

    public static String get(String key, String def) {
        Objects.requireNonNull(key, "key");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key must not be empty.");
        }
        String value = null;
        try {
            value = System.getSecurityManager() == null ? System.getProperty(key) : AccessController.doPrivileged(() -> System.getProperty(key));
        }
        catch (Exception ignore) {
            LOGGER.warn("Unable to retrieve a system property '{}'; default values will be used.", (Object)key, (Object)ignore);
        }
        if (value == null) {
            return def;
        }
        return value;
    }
}

