/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.file;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.file.FileConfigKeys;
import com.antgroup.geaflow.file.IPersistentIO;
import com.antgroup.geaflow.file.PersistentType;
import java.util.ServiceLoader;

public class PersistentIOBuilder {
    public static IPersistentIO build(Configuration userConfig) {
        PersistentType type = PersistentType.valueOf(userConfig.getString(FileConfigKeys.PERSISTENT_TYPE).toUpperCase());
        ServiceLoader<IPersistentIO> serviceLoader = ServiceLoader.load(IPersistentIO.class);
        for (IPersistentIO persistentIO : serviceLoader) {
            if (persistentIO.getPersistentType() != type) continue;
            persistentIO.init(userConfig);
            return persistentIO;
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.spiNotFoundError(type.toString()));
    }
}

