/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.file;

import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class FileInfo {
    private Path path;
    private long modifiedTime;
    private long length;

    protected FileInfo() {
    }

    public static FileInfo of(FileStatus fileStatus) {
        return new FileInfo().withPath(fileStatus.getPath()).withLength(fileStatus.getLen()).withModifiedTime(fileStatus.getModificationTime());
    }

    public static FileInfo of() {
        return new FileInfo();
    }

    public FileInfo withLength(long length) {
        this.length = length;
        return this;
    }

    public FileInfo withPath(Path path) {
        this.path = path;
        return this;
    }

    public FileInfo withModifiedTime(long modifiedTime) {
        this.modifiedTime = modifiedTime;
        return this;
    }

    public Path getPath() {
        return this.path;
    }

    public long getModificationTime() {
        return this.modifiedTime;
    }

    public long getLength() {
        return this.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileInfo fileInfo = (FileInfo)o;
        return this.length == fileInfo.getLength() && this.modifiedTime == fileInfo.modifiedTime && Objects.equals(this.path, fileInfo.path);
    }

    public int hashCode() {
        return Objects.hash(this.length, this.path, this.modifiedTime);
    }
}

